/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasModuleInfo;
import io.atlasmap.core.DefaultAtlasModuleInfoRegistry;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleInfo;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DefaultAtlasModuleInfoRegistryTest {
    private static DefaultAtlasModuleInfoRegistry atlasModuleInfoRegistry;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        DefaultAtlasContextFactory factory = DefaultAtlasContextFactory.getInstance();
        factory.setObjectName();
        atlasModuleInfoRegistry = new DefaultAtlasModuleInfoRegistry(factory);
    }

    @Test
    public void testDefaultAtlasModuleInfoRegistry() {
        Assertions.assertNotNull((Object)atlasModuleInfoRegistry);
    }

    @Test
    public void testLookupByUri() {
        Assertions.assertNull((Object)atlasModuleInfoRegistry.lookupByUri(null));
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("java");
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("io.atlasmap.core");
        DefaultAtlasModuleInfo atlasModuleInfo = new DefaultAtlasModuleInfo("name", "atlas:java", AtlasModule.class, null, formats, packageNames);
        atlasModuleInfoRegistry.register((AtlasModuleInfo)atlasModuleInfo);
        Assertions.assertNotNull((Object)atlasModuleInfoRegistry.lookupByUri("atlas:java"));
        Assertions.assertNull((Object)atlasModuleInfoRegistry.lookupByUri("java"));
    }

    @Test
    public void testGetAll() {
        Assertions.assertNotNull((Object)atlasModuleInfoRegistry.getAll());
    }

    @Test
    public void testRegister() {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("java");
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("io.atlasmap.core");
        DefaultAtlasModuleInfo atlasModuleInfo = new DefaultAtlasModuleInfo("name", "atlas:java", AtlasModule.class, null, formats, packageNames);
        atlasModuleInfoRegistry.register((AtlasModuleInfo)atlasModuleInfo);
        Assertions.assertEquals((int)1, (int)atlasModuleInfoRegistry.size());
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)0, (int)atlasModuleInfoRegistry.size());
    }

    @Test
    public void testUnregisterAll() {
        atlasModuleInfoRegistry.unregisterAll();
        Assertions.assertEquals((int)0, (int)atlasModuleInfoRegistry.size());
    }
}

