/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.BaseDefaultAtlasContextTest;
import io.atlasmap.core.DefaultAtlasExpressionProcessor;
import io.atlasmap.core.DefaultAtlasPropertyStrategy;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.core.PropertyModule;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultAtlasExpressionProcessorTest
extends BaseDefaultAtlasContextTest {
    @Test
    public void testSingle() throws AtlasException {
        Field source = this.populateSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", FieldType.STRING, (Object)"foo");
        String expression = String.format("${%s:/testPathfoo}", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField(source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"foo", (Object)this.session.head().getSourceField().getValue());
    }

    @Test
    public void testCollection() throws Exception {
        FieldGroup source = this.populateCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("IF(ISEMPTY(${%s:/testPathfoo<0>}), null, ${%s:/testPathfoo<>})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        FieldGroup wrapper = new FieldGroup();
        wrapper.getField().add(source);
        wrapper.getField().add((Field)source.getField().get(0));
        this.session.head().setSourceField((Field)wrapper);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assertions.assertEquals((Object)"/testPathfoo<>", (Object)fieldGroup.getPath());
        Assertions.assertEquals((int)10, (int)fieldGroup.getField().size());
        Assertions.assertEquals((Object)"foo0", (Object)((Field)fieldGroup.getField().get(0)).getValue());
    }

    @Test
    public void testComplexCollection() throws Exception {
        this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("IF(ISEMPTY(${%s:/testPathfoo<0>/value}), null, ${%s:/testPathfoo<>/value})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        FieldGroup wrapper = new FieldGroup();
        wrapper.getField().add((Field)this.reader.sources.get("/testPathfoo<0>/value"));
        wrapper.getField().add((Field)this.reader.sources.get("/testPathfoo<>/value"));
        this.session.head().setSourceField((Field)wrapper);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assertions.assertEquals((Object)"/testPathfoo<>/value", (Object)fieldGroup.getPath());
        Assertions.assertEquals((int)10, (int)fieldGroup.getField().size());
        Field childField = (Field)fieldGroup.getField().get(0);
        Assertions.assertEquals((Object)"/testPathfoo<0>/value", (Object)childField.getPath());
        Assertions.assertEquals((Object)"foo0", (Object)childField.getValue());
        childField = (Field)fieldGroup.getField().get(1);
        Assertions.assertEquals((Object)"/testPathfoo<1>/value", (Object)childField.getPath());
        Assertions.assertEquals((Object)"foo1", (Object)childField.getValue());
    }

    @Test
    public void testFilter() throws Exception {
        FieldGroup source = this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("FILTER(${%s:/testPathfoo<>}, ${/value} != 'foo1')", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField((Field)source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assertions.assertEquals((Object)"/testPathfoo<>", (Object)fieldGroup.getPath());
        Assertions.assertEquals((int)9, (int)fieldGroup.getField().size());
        FieldGroup childFieldGroup = (FieldGroup)fieldGroup.getField().get(0);
        Assertions.assertEquals((Object)"/testPathfoo<0>", (Object)childFieldGroup.getPath());
        Assertions.assertEquals((int)1, (int)childFieldGroup.getField().size());
        Assertions.assertEquals((Object)"foo0", (Object)((Field)childFieldGroup.getField().get(0)).getValue());
        childFieldGroup = (FieldGroup)fieldGroup.getField().get(1);
        Assertions.assertEquals((Object)"/testPathfoo<1>", (Object)childFieldGroup.getPath());
        Assertions.assertEquals((int)1, (int)childFieldGroup.getField().size());
        Assertions.assertEquals((Object)"foo2", (Object)((Field)childFieldGroup.getField().get(0)).getValue());
    }

    @Test
    public void testSelect() throws Exception {
        FieldGroup source = this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("SELECT(${%s:/testPathfoo<>}, ${/value})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField((Field)source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assertions.assertEquals((Object)"/testPathfoo<>/value", (Object)fieldGroup.getPath());
        Assertions.assertEquals((int)10, (int)fieldGroup.getField().size());
        Field child = (Field)fieldGroup.getField().get(0);
        Assertions.assertEquals((Object)"/testPathfoo<0>/value", (Object)child.getPath());
        Assertions.assertEquals((Object)"foo0", (Object)child.getValue());
        child = (Field)fieldGroup.getField().get(1);
        Assertions.assertEquals((Object)"/testPathfoo<1>/value", (Object)child.getPath());
        Assertions.assertEquals((Object)"foo1", (Object)child.getValue());
    }

    @Test
    public void testFilterSelect() throws Exception {
        FieldGroup source = this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("SELECT(FILTER(${%s:/testPathfoo<>}, ${/value} != 'foo1'), ${/value})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField((Field)source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assertions.assertEquals((Object)"/testPathfoo<>/value", (Object)fieldGroup.getPath());
        Assertions.assertEquals((int)9, (int)fieldGroup.getField().size());
        Field child = (Field)fieldGroup.getField().get(0);
        Assertions.assertEquals((Object)"/testPathfoo<0>/value", (Object)child.getPath());
        Assertions.assertEquals((Object)"foo0", (Object)child.getValue());
        child = (Field)fieldGroup.getField().get(1);
        Assertions.assertEquals((Object)"/testPathfoo<1>/value", (Object)child.getPath());
        Assertions.assertEquals((Object)"foo2", (Object)child.getValue());
    }

    @Test
    public void testScopedProperty() throws Exception {
        FieldGroup source = new FieldGroup();
        PropertyField doc1Prop = new PropertyField();
        doc1Prop.setDocId("DOC.Properties.85731");
        doc1Prop.setScope("Doc1");
        doc1Prop.setPath("/Doc1/testprop");
        doc1Prop.setName("testprop");
        doc1Prop.setValue((Object)"doc1prop");
        source.getField().add(doc1Prop);
        PropertyField doc2Prop = new PropertyField();
        doc2Prop.setDocId("DOC.Properties.85731");
        doc2Prop.setScope("Doc2");
        doc2Prop.setPath("/Doc2/testprop");
        doc2Prop.setName("testprop");
        doc2Prop.setValue((Object)"doc2prop");
        source.getField().add(doc2Prop);
        PropertyField currentProp = new PropertyField();
        currentProp.setDocId("DOC.Properties.85731");
        currentProp.setPath("/testprop");
        currentProp.setName("testprop");
        currentProp.setValue((Object)"currentprop");
        source.getField().add(currentProp);
        String expression = "${DOC.Properties.85731:/Doc1/testprop} + ${DOC.Properties.85731:/Doc2/testprop} + ${DOC.Properties.85731:/testprop}";
        this.recreateSession();
        this.context.getSourceModules().put("ATLAS_SOURCE_PROPERTIES_DOC", new PropertyModule((AtlasPropertyStrategy)new DefaultAtlasPropertyStrategy()));
        this.session.head().setSourceField((Field)source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals(SimpleField.class, this.session.head().getSourceField().getClass());
        SimpleField field = (SimpleField)this.session.head().getSourceField();
        Assertions.assertEquals((Object)"$ATLASMAP", (Object)field.getPath());
        Assertions.assertEquals((Object)"doc1propdoc2propcurrentprop", (Object)field.getValue());
    }

    @Test
    public void testBoolean() throws AtlasException {
        Field source = this.populateSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", FieldType.BOOLEAN, (Object)true);
        String expression = String.format("IF (${%s:/testPathtrue}, 'YES', 'NO')", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField(source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"YES", (Object)this.session.head().getSourceField().getValue());
        source = this.populateSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", FieldType.BOOLEAN, (Object)true);
        expression = String.format("IF (${%s:/testPathtrue} == true, 'YES', 'NO')", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField(source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"YES", (Object)this.session.head().getSourceField().getValue());
        source = this.populateSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", FieldType.BOOLEAN, (Object)true);
        expression = String.format("IF (${%s:/testPathtrue}, 'YES', 'NO')", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField(source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"YES", (Object)this.session.head().getSourceField().getValue());
        source = this.populateSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", FieldType.BOOLEAN, (Object)true);
        expression = String.format("IF (${%s:/testPathtrue} == true, 'YES', 'NO')", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField(source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"YES", (Object)this.session.head().getSourceField().getValue());
    }

    @Test
    public void testRepeatCount() throws Exception {
        Field source = this.populateSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", FieldType.STRING, (Object)"foo");
        this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "count");
        String expression = String.format("REPEAT(COUNT(${%s:/testPathcount<>/value}), ${%s:/testPathfoo})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        FieldGroup wrapper = new FieldGroup();
        wrapper.getField().add((Field)this.reader.sources.get("/testPathcount<>/value"));
        wrapper.getField().add(source);
        this.session.head().setSourceField((Field)wrapper);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assertions.assertEquals((Object)"/testPathfoo<>", (Object)fieldGroup.getPath());
        Assertions.assertEquals((int)10, (int)fieldGroup.getField().size());
        Field child = (Field)fieldGroup.getField().get(0);
        Assertions.assertEquals((Object)"/testPathfoo<0>", (Object)child.getPath());
        Assertions.assertNull((Object)child.getIndex());
        Assertions.assertEquals((Object)"foo", (Object)child.getValue());
        child = (Field)fieldGroup.getField().get(1);
        Assertions.assertEquals((Object)"/testPathfoo<1>", (Object)child.getPath());
        Assertions.assertNull((Object)child.getIndex());
        Assertions.assertEquals((Object)"foo", (Object)child.getValue());
        child = (Field)fieldGroup.getField().get(9);
        Assertions.assertEquals((Object)"/testPathfoo<9>", (Object)child.getPath());
        Assertions.assertNull((Object)child.getIndex());
        Assertions.assertEquals((Object)"foo", (Object)child.getValue());
    }
}

