/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasCombineStrategy;
import io.atlasmap.spi.AtlasCombineStrategy;
import io.atlasmap.spi.StringDelimiter;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultAtlasCombineStrategyTest {
    private AtlasCombineStrategy combine = null;

    @BeforeEach
    public void setUp() {
        this.combine = new DefaultAtlasCombineStrategy();
    }

    @AfterEach
    public void tearDown() {
        this.combine = null;
    }

    @Test
    public void testGetName() {
        Assertions.assertNotNull((Object)this.combine);
        Assertions.assertEquals((Object)"DefaultAtlasCombineStrategy", (Object)this.combine.getName());
    }

    protected Map<Integer, String> generateCombineMap(int count) {
        String combines = "abcdefghijklmnopqrstuvwxyz";
        HashMap<Integer, String> cMap = new HashMap<Integer, String>();
        for (int i = 0; i < count; ++i) {
            cMap.put(i, combines.substring(i, i + 1));
        }
        return cMap;
    }

    @Test
    public void testGetSetDelimiter() {
        Assertions.assertNotNull((Object)this.combine);
        Assertions.assertNotNull((Object)this.combine.getDelimiter());
        Assertions.assertEquals((Object)DefaultAtlasCombineStrategy.DEFAULT_COMBINE_DELIMITER, (Object)this.combine.getDelimiter());
        this.combine.setDelimiter(StringDelimiter.COLON);
        Assertions.assertEquals((Object)StringDelimiter.COLON, (Object)this.combine.getDelimiter());
        String value = this.combine.combineValues(this.generateCombineMap(4));
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"a:b:c:d", (Object)value);
    }

    @Test
    public void testGetSetLimit() {
        Assertions.assertNotNull((Object)this.combine);
        Assertions.assertNotNull((Object)this.combine.getDelimiter());
        Assertions.assertEquals((Integer)DefaultAtlasCombineStrategy.DEFAULT_COMBINE_LIMIT, (Integer)this.combine.getLimit());
        this.combine.setLimit(Integer.valueOf(2));
        String value = this.combine.combineValues(this.generateCombineMap(4));
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"a b", (Object)value);
    }

    @Test
    public void testGetSetAutoTrim() {
        Assertions.assertNotNull((Object)this.combine);
        Assertions.assertFalse((boolean)((DefaultAtlasCombineStrategy)this.combine).isDisableAutoTrim());
        ((DefaultAtlasCombineStrategy)this.combine).setDisableAutoTrim(true);
        Assertions.assertTrue((boolean)((DefaultAtlasCombineStrategy)this.combine).isDisableAutoTrim());
        Map<Integer, String> cMap = this.generateCombineMap(2);
        cMap.put(0, cMap.get(0) + " ");
        String value = this.combine.combineValues(cMap);
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"a  b", (Object)value);
    }

    @Test
    public void testDisableAutoTrimNullDelimiter() {
        Assertions.assertNotNull((Object)this.combine);
        Assertions.assertFalse((boolean)((DefaultAtlasCombineStrategy)this.combine).isDisableAutoTrim());
        ((DefaultAtlasCombineStrategy)this.combine).setDisableAutoTrim(true);
        Assertions.assertTrue((boolean)((DefaultAtlasCombineStrategy)this.combine).isDisableAutoTrim());
        Map<Integer, String> cMap = this.generateCombineMap(3);
        cMap.put(0, cMap.get(0) + " ");
        cMap.put(2, "  " + cMap.get(2));
        String value = this.combine.combineValues(cMap, null, null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"a  b   c", (Object)value);
    }

    @Test
    public void testCombineSingleValue() {
        Assertions.assertNotNull((Object)this.combine);
        String value = this.combine.combineValues(this.generateCombineMap(1));
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"a", (Object)value);
    }

    @Test
    public void testCombineValues() {
        Assertions.assertNotNull((Object)this.combine);
        String value = this.combine.combineValues(this.generateCombineMap(6));
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"a b c d e f", (Object)value);
    }

    @Test
    public void testCombineValuesNullDelimiter() {
        Assertions.assertNotNull((Object)this.combine);
        this.combine.setDelimiter(null);
        Assertions.assertNull((Object)this.combine.getDelimiter());
        String value = this.combine.combineValues(this.generateCombineMap(6));
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"a b c d e f", (Object)value);
    }

    @Test
    public void testCombineValuesNullLimit() {
        Assertions.assertNotNull((Object)this.combine);
        this.combine.setLimit(null);
        Assertions.assertNull((Object)this.combine.getLimit());
        String value = this.combine.combineValues(this.generateCombineMap(6));
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"a b c d e f", (Object)value);
    }

    @Test
    public void testSeparateValuesNullValue() {
        Assertions.assertNotNull((Object)this.combine);
        String value = this.combine.combineValues(null);
        Assertions.assertNull((Object)value);
    }

    @Test
    public void testCombineValuesEmptyValue() {
        Assertions.assertNotNull((Object)this.combine);
        String value = this.combine.combineValues(new HashMap());
        Assertions.assertNull((Object)value);
    }

    @Test
    public void testSortByKey() {
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(this.generateCombineMap(4));
        Assertions.assertEquals((Object)"a", cMap.get(0));
        Assertions.assertEquals((Object)"b", cMap.get(1));
        Assertions.assertEquals((Object)"c", cMap.get(2));
        Assertions.assertEquals((Object)"d", cMap.get(3));
    }

    @Test
    public void testSortByKeyOutOfOrder() {
        HashMap<Integer, String> outOfOrder = new HashMap<Integer, String>();
        outOfOrder.put(2, "c");
        outOfOrder.put(0, "a");
        outOfOrder.put(3, "d");
        outOfOrder.put(1, "b");
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(outOfOrder);
        int count = 0;
        for (String str : cMap.values()) {
            if (count == 0) {
                Assertions.assertEquals((Object)"a", (Object)str);
            }
            if (count == 1) {
                Assertions.assertEquals((Object)"b", (Object)str);
            }
            if (count == 2) {
                Assertions.assertEquals((Object)"c", (Object)str);
            }
            if (count == 3) {
                Assertions.assertEquals((Object)"d", (Object)str);
            }
            ++count;
        }
    }

    @Test
    public void testSortByKeyOutOfOrderGaps() {
        HashMap<Integer, String> outOfOrder = new HashMap<Integer, String>();
        outOfOrder.put(7, "c");
        outOfOrder.put(3, "a");
        outOfOrder.put(99, "d");
        outOfOrder.put(5, "b");
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(outOfOrder);
        int count = 0;
        for (String str : cMap.values()) {
            if (count == 0) {
                Assertions.assertEquals((Object)"a", (Object)str);
            }
            if (count == 1) {
                Assertions.assertEquals((Object)"b", (Object)str);
            }
            if (count == 2) {
                Assertions.assertEquals((Object)"c", (Object)str);
            }
            if (count == 3) {
                Assertions.assertEquals((Object)"d", (Object)str);
            }
            ++count;
        }
    }

    @Test
    public void testSortByKeyWithNullKey() {
        Map<Integer, String> generatedCombineMap = this.generateCombineMap(4);
        generatedCombineMap.put(null, "valueWithNullKey");
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(generatedCombineMap);
        Assertions.assertEquals((Object)"a", cMap.get(0));
        Assertions.assertEquals((Object)"b", cMap.get(1));
        Assertions.assertEquals((Object)"c", cMap.get(2));
        Assertions.assertEquals((Object)"d", cMap.get(3));
        Assertions.assertEquals((Object)"valueWithNullKey", cMap.get(null));
    }

    @Test
    public void testSortByKeyWithNullValue() {
        Map<Integer, String> generatedCombineMap = this.generateCombineMap(4);
        generatedCombineMap.put(4, null);
        generatedCombineMap.put(5, "f");
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(generatedCombineMap);
        Assertions.assertEquals((Object)"a", cMap.get(0));
        Assertions.assertEquals((Object)"b", cMap.get(1));
        Assertions.assertEquals((Object)"c", cMap.get(2));
        Assertions.assertEquals((Object)"d", cMap.get(3));
        Assertions.assertEquals(null, cMap.get(4));
        Assertions.assertEquals((Object)"f", cMap.get(5));
    }
}

