/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.FloatConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FloatConverterTest {
    private FloatConverter converter = new FloatConverter();

    @Test
    public void convertToBoolean() {
        Float df = Float.valueOf(0.0f);
        Float dt = Float.valueOf(1.0f);
        Boolean b = this.converter.toBoolean(dt);
        Assertions.assertNotNull((Object)b);
        Assertions.assertTrue((boolean)b);
        b = this.converter.toBoolean(df);
        Assertions.assertNotNull((Object)b);
        Assertions.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Float df = null;
        Boolean b = this.converter.toBoolean(df);
        Assertions.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanNegative() {
        Float dt = Float.valueOf(-1.0f);
        Boolean b = this.converter.toBoolean(dt);
        Assertions.assertTrue((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        Float df = Float.valueOf(0.0f);
        Byte value = 0;
        Assertions.assertEquals((Byte)value, (Byte)this.converter.toByte(df));
    }

    @Test
    public void convertToByteOutOfRange() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Float df = Float.valueOf(Float.MAX_VALUE);
            this.converter.toByte(df);
        });
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assertions.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() throws Exception {
        Float df = Float.valueOf(0.0f);
        Character c = this.converter.toCharacter(df);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((int)0, (int)c.charValue());
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Float df = null;
        Character c = this.converter.toCharacter(df);
        Assertions.assertNull((Object)c);
    }

    @Test
    public void convertToCharacterMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Float df = Float.valueOf(Float.MAX_VALUE);
            this.converter.toCharacter(df);
        });
    }

    @Test
    public void convertToCharacterMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Float df = Float.valueOf(-1.0f);
            this.converter.toCharacter(df);
        });
    }

    @Test
    public void convertToDouble() {
        Float df = Float.valueOf(0.0f);
        Double d = this.converter.toDouble(df);
        Assertions.assertNotNull((Object)d);
        Assertions.assertNotSame((Object)df, (Object)d);
        Assertions.assertEquals((double)0.0, (double)d.floatValue(), (double)0.0);
        df = Float.valueOf(1.0f);
        d = this.converter.toDouble(df);
        Assertions.assertNotNull((Object)d);
        Assertions.assertNotSame((Object)df, (Object)d);
        Assertions.assertEquals((double)1.0, (double)d.floatValue(), (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Float df = null;
        Double d = this.converter.toDouble(df);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToFloat() {
        Float df = Float.valueOf(0.0f);
        Float d = this.converter.toFloat(df);
        Assertions.assertNotNull((Object)d);
        Assertions.assertNotSame((Object)df, (Object)d);
        Assertions.assertEquals((double)0.0, (double)d.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Float df = null;
        Float d = this.converter.toFloat(df);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToInteger() throws Exception {
        Float df = Float.valueOf(0.15f);
        Integer i = this.converter.toInteger(df);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() throws Exception {
        Float df = null;
        Integer i = this.converter.toInteger(df);
        Assertions.assertNull((Object)i);
    }

    @Test
    public void convertToIntegerExceptionMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Float df = Float.valueOf(Float.MAX_VALUE);
            this.converter.toInteger(df);
        });
    }

    @Test
    public void convertToLong() throws Exception {
        Float df = Float.valueOf(0.0f);
        Long l = this.converter.toLong(df);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)0.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() throws Exception {
        Float df = null;
        Long l = this.converter.toLong(df);
        Assertions.assertNull((Object)l);
    }

    @Test
    public void convertToLongExceptionMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Float df = Float.valueOf(Float.MAX_VALUE);
            this.converter.toLong(df);
        });
    }

    @Test
    public void convertToShort() throws Exception {
        Float df = Float.valueOf(0.0f);
        Short s = this.converter.toShort(df);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Float df = null;
        Short s = this.converter.toShort(df);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void convertToShortExceptionMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Float df = Float.valueOf(Float.MAX_VALUE);
            this.converter.toShort(df);
        });
    }

    @Test
    public void convertToString() {
        Float df = Float.valueOf(0.0f);
        String s = this.converter.toString(df);
        Assertions.assertNotNull((Object)s);
        Assertions.assertTrue((boolean)"0.0".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Float df = null;
        String s = this.converter.toString(df);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<FloatConverter> aClass = FloatConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assertions.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.FLOAT) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

