/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.StringComplexFieldActions;
import io.atlasmap.v2.Append;
import io.atlasmap.v2.Concatenate;
import io.atlasmap.v2.EndsWith;
import io.atlasmap.v2.Format;
import io.atlasmap.v2.GenerateUUID;
import io.atlasmap.v2.IndexOf;
import io.atlasmap.v2.LastIndexOf;
import io.atlasmap.v2.PadStringLeft;
import io.atlasmap.v2.PadStringRight;
import io.atlasmap.v2.Prepend;
import io.atlasmap.v2.ReplaceAll;
import io.atlasmap.v2.ReplaceFirst;
import io.atlasmap.v2.Split;
import io.atlasmap.v2.StartsWith;
import io.atlasmap.v2.SubString;
import io.atlasmap.v2.SubStringAfter;
import io.atlasmap.v2.SubStringBefore;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringComplexFieldActionsTest {
    @Test
    public void testAppend() {
        Append action = new Append();
        Assertions.assertEquals(null, (Object)StringComplexFieldActions.append((Append)action, null));
        Assertions.assertEquals((Object)"foo", (Object)StringComplexFieldActions.append((Append)action, (String)"foo"));
        Assertions.assertEquals((Object)"1", (Object)StringComplexFieldActions.append((Append)action, (String)"1"));
        action.setString("");
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.append((Append)action, null));
        Assertions.assertEquals((Object)"foo", (Object)StringComplexFieldActions.append((Append)action, (String)"foo"));
        action.setString("bar");
        Assertions.assertEquals((Object)"bar", (Object)StringComplexFieldActions.append((Append)action, null));
        Assertions.assertEquals((Object)"foobar", (Object)StringComplexFieldActions.append((Append)action, (String)"foo"));
        Assertions.assertEquals((Object)"1bar", (Object)StringComplexFieldActions.append((Append)action, (String)"1"));
    }

    @Test
    public void testAppendNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.append(null, null));
    }

    @Test
    public void testConcatenate() {
        Concatenate action = new Concatenate();
        Assertions.assertEquals(null, (Object)StringComplexFieldActions.concatenate((Concatenate)action, null));
        Assertions.assertEquals((Object)"1true2.0", (Object)StringComplexFieldActions.concatenate((Concatenate)action, Arrays.asList("1", "true", "2.0")));
        Assertions.assertEquals((Object)"1true2.0", (Object)StringComplexFieldActions.concatenate((Concatenate)action, Arrays.asList("1", "true", "2.0")));
        action.setDelimiter("-");
        Assertions.assertEquals(null, (Object)StringComplexFieldActions.concatenate((Concatenate)action, null));
        Assertions.assertEquals((Object)"1-true-2.0", (Object)StringComplexFieldActions.concatenate((Concatenate)action, Arrays.asList("1", "true", "2.0")));
        Assertions.assertEquals((Object)"1-true-2.0", (Object)StringComplexFieldActions.concatenate((Concatenate)action, Arrays.asList("1", "true", "2.0")));
    }

    @Test
    public void testConcatenateNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.concatenate(null, null));
    }

    @Test
    public void testEndsWith() {
        EndsWith action = new EndsWith();
        action.setString("");
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, null));
        Assertions.assertTrue((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)""));
        Assertions.assertTrue((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)"foo"));
        action.setString("bar");
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, null));
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)""));
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)"foo"));
        Assertions.assertTrue((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)"foobar"));
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)"barfoo"));
    }

    @Test
    public void testEndsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.endsWith(null, null));
    }

    @Test
    public void testEndsWithNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.endsWith((EndsWith)new EndsWith(), null));
    }

    @Test
    public void testFormat() {
        Format action = new Format();
        action.setTemplate("foofoo");
        Assertions.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format((Format)action, null));
        Assertions.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("")));
        Assertions.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("bar")));
        action.setTemplate("foo%sfoo");
        Assertions.assertEquals((Object)"foonullfoo", (Object)StringComplexFieldActions.format((Format)action, null));
        Assertions.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("")));
        Assertions.assertEquals((Object)"foobarfoo", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("bar")));
        action.setTemplate("foo%1$sfoo%1$s");
        Assertions.assertEquals((Object)"foobarfoobar", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("bar")));
    }

    @Test
    public void testFormatNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.format(null, null));
    }

    @Test
    public void testFormatNullTemplate() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.format((Format)new Format(), null));
    }

    @Test
    public void testGenareteUUID() {
        this.validateGeneratedUUID(StringComplexFieldActions.genareteUUID((GenerateUUID)new GenerateUUID()));
    }

    @Test
    public void testIndexOf() {
        IndexOf action = new IndexOf();
        action.setString("");
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf((IndexOf)action, null));
        Assertions.assertEquals((Object)0, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)""));
        Assertions.assertEquals((Object)0, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)"foo"));
        action.setString("bar");
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf((IndexOf)action, null));
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)""));
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)"foo"));
        Assertions.assertEquals((Object)3, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)"foobar"));
        Assertions.assertEquals((Object)3, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)"foobarbar"));
    }

    @Test
    public void testIndexOfNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.indexOf(null, null));
    }

    @Test
    public void testIndexOfNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.indexOf((IndexOf)new IndexOf(), null));
    }

    @Test
    public void testLastIndexOf() {
        LastIndexOf action = new LastIndexOf();
        action.setString("");
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, null));
        Assertions.assertEquals((Object)0, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)""));
        Assertions.assertEquals((Object)3, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)"foo"));
        action.setString("bar");
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, null));
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)""));
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)"foo"));
        Assertions.assertEquals((Object)3, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)"foobar"));
        Assertions.assertEquals((Object)6, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)"foobarbar"));
    }

    @Test
    public void testLastIndexOfNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.lastIndexOf(null, null));
    }

    @Test
    public void testLastIndexOfNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.lastIndexOf((LastIndexOf)new LastIndexOf(), null));
    }

    @Test
    public void testPadStringLeft() {
        PadStringLeft incomplete;
        PadStringLeft padStringLeft = new PadStringLeft();
        padStringLeft.setPadCharacter("a");
        padStringLeft.setPadCount(Integer.valueOf(3));
        Assertions.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringLeft((PadStringLeft)padStringLeft, null));
        Assertions.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringLeft((PadStringLeft)padStringLeft, (String)""));
        Assertions.assertEquals((Object)"aaaa", (Object)StringComplexFieldActions.padStringLeft((PadStringLeft)padStringLeft, (String)"a"));
        Assertions.assertEquals((Object)"aaab", (Object)StringComplexFieldActions.padStringLeft((PadStringLeft)padStringLeft, (String)"b"));
        try {
            StringComplexFieldActions.padStringLeft(null, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            StringComplexFieldActions.padStringLeft((PadStringLeft)new PadStringLeft(), (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            incomplete = new PadStringLeft();
            incomplete.setPadCharacter("f");
            StringComplexFieldActions.padStringLeft((PadStringLeft)incomplete, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            incomplete = new PadStringLeft();
            incomplete.setPadCount(Integer.valueOf(3));
            StringComplexFieldActions.padStringLeft((PadStringLeft)incomplete, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testPadStringRight() {
        PadStringRight incomplete2;
        PadStringRight padStringRight = new PadStringRight();
        padStringRight.setPadCharacter("a");
        padStringRight.setPadCount(Integer.valueOf(3));
        Assertions.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringRight((PadStringRight)padStringRight, null));
        Assertions.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringRight((PadStringRight)padStringRight, (String)""));
        Assertions.assertEquals((Object)"aaaa", (Object)StringComplexFieldActions.padStringRight((PadStringRight)padStringRight, (String)"a"));
        Assertions.assertEquals((Object)"baaa", (Object)StringComplexFieldActions.padStringRight((PadStringRight)padStringRight, (String)"b"));
        try {
            StringComplexFieldActions.padStringRight(null, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringComplexFieldActions.padStringRight((PadStringRight)new PadStringRight(), (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            incomplete2 = new PadStringRight();
            incomplete2.setPadCharacter("f");
            StringComplexFieldActions.padStringRight((PadStringRight)incomplete2, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException incomplete2) {
            // empty catch block
        }
        try {
            incomplete2 = new PadStringRight();
            incomplete2.setPadCount(Integer.valueOf(3));
            StringComplexFieldActions.padStringRight((PadStringRight)incomplete2, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPrepend() {
        Prepend action = new Prepend();
        Assertions.assertEquals(null, (Object)StringComplexFieldActions.prepend((Prepend)action, null));
        Assertions.assertEquals((Object)"foo", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"foo"));
        Assertions.assertEquals((Object)"1", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"1"));
        action.setString("");
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.prepend((Prepend)action, null));
        Assertions.assertEquals((Object)"foo", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"foo"));
        action.setString("bar");
        Assertions.assertEquals((Object)"bar", (Object)StringComplexFieldActions.prepend((Prepend)action, null));
        Assertions.assertEquals((Object)"barfoo", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"foo"));
        Assertions.assertEquals((Object)"bar1", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"1"));
    }

    @Test
    public void testPrependNullAction() {
        Assertions.assertThrows(NullPointerException.class, () -> StringComplexFieldActions.prepend(null, null));
    }

    @Test
    public void testReplaceFirst() {
        ReplaceFirst replaceFirst = new ReplaceFirst();
        replaceFirst.setMatch(" ");
        Assertions.assertNull((Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)""));
        Assertions.assertEquals((Object)"test", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)"test"));
        replaceFirst.setMatch("e");
        Assertions.assertEquals((Object)"tst", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)"test"));
        replaceFirst.setMatch("t");
        replaceFirst.setNewString("h");
        Assertions.assertEquals((Object)"hest", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)"test"));
        replaceFirst.setMatch("is");
        replaceFirst.setNewString("at");
        Assertions.assertEquals((Object)"That is a test", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)"This is a test"));
    }

    @Test
    public void testReplaceFirstEmptyMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ReplaceFirst replaceFirst = new ReplaceFirst();
            replaceFirst.setMatch("");
            StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)" ");
        });
    }

    @Test
    public void testReplaceFirstNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.replaceFirst(null, null));
    }

    @Test
    public void testReplaceFirstNullMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ReplaceFirst replaceFirst = new ReplaceFirst();
            StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)" ");
        });
    }

    @Test
    public void testReplaceAll() {
        ReplaceAll replaceAll = new ReplaceAll();
        replaceAll.setMatch(" ");
        Assertions.assertNull((Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)""));
        Assertions.assertEquals((Object)"test", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)"test"));
        replaceAll.setMatch("e");
        Assertions.assertEquals((Object)"tst", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)"test"));
        replaceAll.setMatch("t");
        replaceAll.setNewString("h");
        Assertions.assertEquals((Object)"hesh", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)"test"));
        replaceAll.setMatch("is");
        replaceAll.setNewString("at");
        Assertions.assertEquals((Object)"That at a test", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)"This is a test"));
    }

    @Test
    public void testReplaceAllEmptyMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ReplaceAll replaceAll = new ReplaceAll();
            replaceAll.setMatch("");
            StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)" ");
        });
    }

    @Test
    public void testReplaceAllNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.replaceAll(null, null));
    }

    @Test
    public void testReplaceAllNullOldString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ReplaceAll replaceAll = new ReplaceAll();
            StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)" ");
        });
    }

    @Test
    public void testSplitNoDelimiter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Split action = new Split();
            StringComplexFieldActions.split((Split)action, (String)"foobar");
        });
    }

    @Test
    public void testSplit() {
        Split action = new Split();
        action.setDelimiter(",");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1,2,3"));
    }

    @Test
    public void testSplitEscape() {
        Split action = new Split();
        action.setDelimiter("\\");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1\\2\\3"));
        action.setDelimiter("|");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1|2|3"));
        action.setDelimiter(".");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1.2.3"));
        action.setDelimiter("$");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1$2$3"));
    }

    @Test
    public void testSplitCollapse() {
        Split action = new Split();
        action.setCollapseRepeatingDelimiters(Boolean.valueOf(true));
        action.setDelimiter("\\");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1\\2\\\\3"));
        action.setDelimiter("|");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1|2|||3"));
        action.setDelimiter(".");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1..2...3"));
        action.setDelimiter("$");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1$$$$2$$$$3"));
        action.setDelimiter(" ");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1  2     3"));
    }

    @Test
    public void testStartsWith() {
        StartsWith action = new StartsWith();
        action.setString("");
        Assertions.assertFalse((boolean)StringComplexFieldActions.startsWith((StartsWith)action, null));
        Assertions.assertTrue((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)""));
        Assertions.assertTrue((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)"foo"));
        action.setString("foo");
        Assertions.assertFalse((boolean)StringComplexFieldActions.startsWith((StartsWith)action, null));
        Assertions.assertFalse((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)""));
        Assertions.assertTrue((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)"foo"));
        Assertions.assertTrue((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)"foobar"));
        Assertions.assertFalse((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)"barfoo"));
    }

    @Test
    public void testStartsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.startsWith(null, null));
    }

    @Test
    public void testStartsWithNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.startsWith((StartsWith)new StartsWith(), null));
    }

    @Test
    public void testSubString() {
        SubString action = new SubString();
        action.setStartIndex(Integer.valueOf(2));
        action.setEndIndex(Integer.valueOf(4));
        Assertions.assertNull((Object)StringComplexFieldActions.subString((SubString)action, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subString((SubString)action, (String)""));
        try {
            StringComplexFieldActions.subString(null, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSubStringAfter() {
        SubStringAfter err;
        SubStringAfter action = new SubStringAfter();
        action.setStartIndex(Integer.valueOf(3));
        action.setEndIndex(null);
        action.setMatch("foo");
        Assertions.assertNull((Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)""));
        Assertions.assertEquals((Object)"blah", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"foobarblah"));
        Assertions.assertEquals((Object)"blahfoo", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"foobarblahfoo"));
        Assertions.assertEquals((Object)"barblah", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"barblah"));
        action.setEndIndex(Integer.valueOf(7));
        Assertions.assertEquals((Object)"blah", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"foobarblahfoo"));
        action.setEndIndex(Integer.valueOf(3));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"foobarblahfoo"));
        try {
            StringComplexFieldActions.subStringAfter(null, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            StringComplexFieldActions.subStringAfter((SubStringAfter)err, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            err.setEndIndex(Integer.valueOf(5));
            err.setStartIndex(Integer.valueOf(0));
            StringComplexFieldActions.subStringAfter((SubStringAfter)err, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            err.setEndIndex(Integer.valueOf(0));
            err.setStartIndex(Integer.valueOf(5));
            StringComplexFieldActions.subStringAfter((SubStringAfter)err, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSubStringBefore() {
        SubStringBefore err;
        SubStringBefore action = new SubStringBefore();
        action.setStartIndex(Integer.valueOf(3));
        action.setEndIndex(null);
        action.setMatch("blah");
        Assertions.assertNull((Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)""));
        Assertions.assertEquals((Object)"bar", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"foobarblah"));
        Assertions.assertEquals((Object)"foobar", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"foofoobarblahfoo"));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"barblah"));
        action.setEndIndex(Integer.valueOf(5));
        Assertions.assertEquals((Object)"ba", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"foobarblah"));
        action.setEndIndex(Integer.valueOf(3));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"foobarblah"));
        try {
            StringComplexFieldActions.subStringBefore(null, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            StringComplexFieldActions.subStringBefore((SubStringBefore)err, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            err.setEndIndex(Integer.valueOf(5));
            err.setStartIndex(Integer.valueOf(0));
            StringComplexFieldActions.subStringBefore((SubStringBefore)err, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            err.setEndIndex(Integer.valueOf(0));
            err.setStartIndex(Integer.valueOf(5));
            StringComplexFieldActions.subStringBefore((SubStringBefore)err, (String)"aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    protected void validateCurrentDate(String dateValue) {
        Assertions.assertNotNull((Object)dateValue);
        Assertions.assertTrue((dateValue.length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("20([1-9][0-9])-(0[0-9]|1[0-2])-(0[0-9]|1[0-9]|2[0-9]|3[0-1])").matcher(dateValue).matches());
    }

    protected void validateCurrentDateTime(String dateTimeValue) {
        Assertions.assertNotNull((Object)dateTimeValue);
        Assertions.assertTrue((dateTimeValue.length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("20([1-9][0-9])-(0[0-9]|1[0-2])-(0[0-9]|1[0-9]|2[0-9]|3[0-1])T([01]?[0-9]|2[0-3]):[0-5][0-9]Z").matcher(dateTimeValue).matches());
    }

    protected void validateCurrentTime(String timeValue) {
        Assertions.assertNotNull((Object)timeValue);
        Assertions.assertTrue((timeValue.length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]").matcher(timeValue).matches());
    }

    protected void validateGeneratedUUID(String uuid) {
        Assertions.assertNotNull((Object)uuid);
        Assertions.assertTrue((uuid.length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matcher(uuid).matches());
    }
}

