/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.spi;

import io.atlasmap.spi.AtlasConversionInfo;

public enum AtlasConversionConcern {
    NONE("none", "Conversion from '%s' to '%s' is supported"),
    RANGE("range", "Conversion from '%s' to '%s' can cause out of range exceptions"),
    FRACTIONAL_PART("fractional part", "Conversion from '%s' to '%s' can cause fractional part to be lost"),
    TIMEZONE("timezone", "Conversion from '%s' to '%s' causes timezone part to be lost"),
    FORMAT("format", "Conversion from '%s' to '%s' can cause numeric format exceptions"),
    CONVENTION("format", "Conversion from '%s' to '%s' uses a default convention for values"),
    UNSUPPORTED("unsupported", "Conversions from '%s' to '%s' is not supported");

    private String name;
    private String message;

    private AtlasConversionConcern(String name, String message) {
        this.name = name;
        this.message = message;
    }

    public String value() {
        return this.name;
    }

    public String getMessage(AtlasConversionInfo converterAnno) {
        return String.format(this.message, converterAnno.sourceType(), converterAnno.targetType());
    }

    public static AtlasConversionConcern fromValue(String v) {
        for (AtlasConversionConcern c : AtlasConversionConcern.values()) {
            if (!c.name().equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }
}

