/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.ServerVersion;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public final class HandshakeHeader {
    private final short protocolVersion;
    private final ServerVersion serverVersion;
    private final int connectionId;

    private HandshakeHeader(short protocolVersion, ServerVersion serverVersion, int connectionId) {
        this.protocolVersion = protocolVersion;
        this.serverVersion = AssertUtils.requireNonNull(serverVersion, "serverVersion must not be null");
        this.connectionId = connectionId;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    static HandshakeHeader decode(ByteBuf buf) {
        short protocolVersion = buf.readUnsignedByte();
        ServerVersion serverVersion = ServerVersion.parse(HandshakeHeader.readCStringAscii(buf));
        return new HandshakeHeader(protocolVersion, serverVersion, buf.readIntLE());
    }

    public String toString() {
        return "HandshakeHeader{protocolVersion=" + this.protocolVersion + ", serverVersion=" + this.serverVersion + ", connectionId=" + this.connectionId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandshakeHeader)) {
            return false;
        }
        HandshakeHeader that = (HandshakeHeader)o;
        return this.protocolVersion == that.protocolVersion && this.connectionId == that.connectionId && this.serverVersion.equals(that.serverVersion);
    }

    public int hashCode() {
        int hash = 31 * this.protocolVersion + this.serverVersion.hashCode();
        return 31 * hash + this.connectionId;
    }

    static String readCStringAscii(ByteBuf buf) {
        int length = buf.bytesBefore((byte)0);
        if (length < 0) {
            throw new IllegalArgumentException("buf has no C-style string terminal");
        }
        if (length == 0) {
            buf.skipBytes(1);
            return "";
        }
        String result = buf.toString(buf.readerIndex(), length, StandardCharsets.US_ASCII);
        buf.skipBytes(length + 1);
        return result;
    }
}

