/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.constant;

import io.asyncer.r2dbc.mysql.api.MySqlNativeTypeMetadata;
import io.r2dbc.spi.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public enum MySqlType implements Type
{
    UNKNOWN(-1, Object.class),
    DECIMAL(246, (Class)BigDecimal.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public boolean isFractional() {
            return true;
        }
    }
    ,
    TINYINT(1, (Class)Byte.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 1;
        }
    }
    ,
    TINYINT_UNSIGNED(1, (Class)Short.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 1;
        }
    }
    ,
    SMALLINT(2, (Class)Short.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 2;
        }
    }
    ,
    SMALLINT_UNSIGNED(2, (Class)Integer.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 2;
        }
    }
    ,
    INT(3, (Class)Integer.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 4;
        }
    }
    ,
    INT_UNSIGNED(3, (Class)Long.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 4;
        }
    }
    ,
    FLOAT(4, (Class)Float.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public boolean isFractional() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 4;
        }
    }
    ,
    DOUBLE(5, (Class)Double.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public boolean isFractional() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 8;
        }
    }
    ,
    NULL(6, Object.class),
    TIMESTAMP(7, ZonedDateTime.class),
    BIGINT(8, (Class)Long.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 8;
        }
    }
    ,
    BIGINT_UNSIGNED(8, (Class)BigInteger.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 8;
        }
    }
    ,
    MEDIUMINT(9, (Class)Integer.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 4;
        }
    }
    ,
    MEDIUMINT_UNSIGNED(9, (Class)Integer.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 4;
        }
    }
    ,
    DATE(10, LocalDate.class),
    TIME(11, LocalTime.class),
    DATETIME(12, LocalDateTime.class),
    YEAR(13, (Class)Short.class){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public int getBinarySize() {
            return 2;
        }
    }
    ,
    VARCHAR(253, (Class)String.class){

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    BIT(16, (Class)ByteBuffer.class){

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    JSON(245, (Class)String.class){

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    ENUM(247, (Class)String.class){

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    SET(248, (Class)String[].class){

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    TINYBLOB(249, (Class)ByteBuffer.class){

        @Override
        public boolean isLob() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    TINYTEXT(249, (Class)String.class){

        @Override
        public boolean isLob() {
            return true;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    MEDIUMBLOB(250, (Class)ByteBuffer.class){

        @Override
        public boolean isLob() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    MEDIUMTEXT(250, (Class)String.class){

        @Override
        public boolean isLob() {
            return true;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    LONGBLOB(251, (Class)ByteBuffer.class){

        @Override
        public boolean isLob() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    LONGTEXT(251, (Class)String.class){

        @Override
        public boolean isLob() {
            return true;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    BLOB(252, (Class)ByteBuffer.class){

        @Override
        public boolean isLob() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    TEXT(252, (Class)String.class){

        @Override
        public boolean isLob() {
            return true;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    VARBINARY(253, (Class)ByteBuffer.class){

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    GEOMETRY(255, (Class)byte[].class){

        @Override
        public boolean isBinary() {
            return true;
        }
    };

    private static final short ID_DECIMAL = 0;
    private static final short ID_TINYINT = 1;
    private static final short ID_SMALLINT = 2;
    private static final short ID_INT = 3;
    private static final short ID_FLOAT = 4;
    private static final short ID_DOUBLE = 5;
    private static final short ID_NULL = 6;
    private static final short ID_TIMESTAMP = 7;
    private static final short ID_BIGINT = 8;
    private static final short ID_MEDIUMINT = 9;
    private static final short ID_DATE = 10;
    private static final short ID_TIME = 11;
    private static final short ID_DATETIME = 12;
    private static final short ID_YEAR = 13;
    private static final short ID_VARCHAR = 15;
    private static final short ID_BIT = 16;
    private static final short ID_JSON = 245;
    private static final short ID_NEW_DECIMAL = 246;
    private static final short ID_ENUM = 247;
    private static final short ID_SET = 248;
    private static final short ID_TINYBLOB = 249;
    private static final short ID_MEDIUMBLOB = 250;
    private static final short ID_LONGBLOB = 251;
    private static final short ID_BLOB = 252;
    private static final short ID_VAR_STRING = 253;
    private static final short ID_STRING = 254;
    private static final short ID_GEOMETRY = 255;
    private final short id;
    private final Class<?> javaType;

    private MySqlType(short id, Class<?> javaType) {
        this.id = id;
        this.javaType = javaType;
    }

    public int getId() {
        return this.id;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String getName() {
        return this.name();
    }

    public boolean isLob() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isFractional() {
        return false;
    }

    public boolean isBinary() {
        return false;
    }

    public int getBinarySize() {
        return 0;
    }

    public static MySqlType of(MySqlNativeTypeMetadata metadata) {
        if (metadata.isSet()) {
            return SET;
        }
        if (metadata.isEnum()) {
            return ENUM;
        }
        switch (metadata.getTypeId()) {
            case 0: 
            case 246: {
                return DECIMAL;
            }
            case 1: {
                return metadata.isUnsigned() ? TINYINT_UNSIGNED : TINYINT;
            }
            case 2: {
                return metadata.isUnsigned() ? SMALLINT_UNSIGNED : SMALLINT;
            }
            case 3: {
                return metadata.isUnsigned() ? INT_UNSIGNED : INT;
            }
            case 4: {
                return FLOAT;
            }
            case 5: {
                return DOUBLE;
            }
            case 6: {
                return NULL;
            }
            case 7: {
                return TIMESTAMP;
            }
            case 8: {
                return metadata.isUnsigned() ? BIGINT_UNSIGNED : BIGINT;
            }
            case 9: {
                return metadata.isUnsigned() ? MEDIUMINT_UNSIGNED : MEDIUMINT;
            }
            case 10: {
                return DATE;
            }
            case 11: {
                return TIME;
            }
            case 12: {
                return DATETIME;
            }
            case 13: {
                return YEAR;
            }
            case 15: 
            case 253: 
            case 254: {
                return metadata.isBinary() ? VARBINARY : VARCHAR;
            }
            case 16: {
                return BIT;
            }
            case 245: {
                return JSON;
            }
            case 247: {
                return ENUM;
            }
            case 248: {
                return SET;
            }
            case 249: {
                return metadata.isBinary() ? TINYBLOB : TINYTEXT;
            }
            case 250: {
                return metadata.isBinary() ? MEDIUMBLOB : MEDIUMTEXT;
            }
            case 251: {
                return metadata.isBinary() ? LONGBLOB : LONGTEXT;
            }
            case 252: {
                return metadata.isBinary() ? BLOB : TEXT;
            }
            case 255: {
                return GEOMETRY;
            }
        }
        return UNKNOWN;
    }
}

