/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.client.ActiveStatus;
import io.asyncer.r2dbc.mysql.client.RequestTask;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;
import reactor.util.concurrent.Queues;

final class RequestQueue
extends ActiveStatus
implements Runnable {
    private final Queue<RequestTask<?>> queue = (Queue)Queues.small().get();
    private final ReentrantLock lock = new ReentrantLock();
    @Nullable
    private volatile RuntimeException disposed;

    RequestQueue() {
    }

    @Override
    public void run() {
        while (true) {
            RequestTask<?> task = this.queue.poll();
            int status = this.status;
            if (task == null) {
                if (status == 1 && (!STATUS_UPDATER.compareAndSet(this, 1, 0) || !this.queue.isEmpty())) continue;
                return;
            }
            if (status == -1) {
                task.cancel(this.requireDisposed());
                return;
            }
            task.run();
            if (!task.isCancelled()) break;
        }
    }

    <T> void submit(RequestTask<T> task) {
        int status = this.status;
        if (status == -1) {
            task.cancel(this.requireDisposed());
            return;
        }
        if (!this.queue.offer(task)) {
            task.cancel(new IllegalStateException("Request queue is full"));
            return;
        }
        if (STATUS_UPDATER.compareAndSet(this, 0, 1)) {
            this.run();
        } else {
            status = this.status;
            if (status == -1) {
                this.cancelAll(this.requireDisposed());
            }
        }
    }

    long keeping(int v) {
        this.p8 = v;
        this.pe = this.pf = (long)this.p8;
        this.pd = this.pf;
        this.pc = this.pf;
        this.pb = this.pf;
        this.pa = this.pf;
        this.p9 = this.pf;
        this.p7 = this.pf;
        this.p6 = this.pf;
        this.p5 = this.pf;
        this.p4 = this.pf;
        this.p3 = this.pf;
        this.p2 = this.pf;
        this.p1 = this.pf;
        this.p0 = this.pf;
        return this.pf;
    }

    void dispose() {
        STATUS_UPDATER.set(this, -1);
        this.cancelAll(this.requireDisposed());
    }

    private RuntimeException requireDisposed() {
        RuntimeException disposed = this.disposed;
        if (disposed == null) {
            this.lock.lock();
            try {
                disposed = this.disposed;
                if (disposed == null) {
                    this.disposed = disposed = new IllegalStateException("Request queue was disposed");
                }
                RuntimeException runtimeException = disposed;
                return runtimeException;
            }
            finally {
                this.lock.unlock();
            }
        }
        return disposed;
    }

    private void cancelAll(RuntimeException e) {
        RequestTask<?> task;
        while ((task = this.queue.poll()) != null) {
            task.cancel(e);
        }
    }
}

