/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.BaseFluxExchangeable;
import io.asyncer.r2dbc.mysql.Binding;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.asyncer.r2dbc.mysql.message.client.PreparedTextQueryMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Sinks;
import reactor.core.publisher.SynchronousSink;

final class TextQueryExchangeable
extends BaseFluxExchangeable {
    private final AtomicBoolean disposed = new AtomicBoolean();
    private final Query query;
    private final String returning;
    private final Iterator<Binding> bindings;

    TextQueryExchangeable(Query query, String returning, Iterator<Binding> bindings) {
        this.query = query;
        this.returning = returning;
        this.bindings = bindings;
    }

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.requests.tryEmitComplete();
            while (this.bindings.hasNext()) {
                this.bindings.next().clear();
            }
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    @Override
    protected void tryNextOrComplete(@Nullable SynchronousSink<ServerMessage> sink) {
        if (this.bindings.hasNext()) {
            PreparedTextQueryMessage message = this.bindings.next().toTextMessage(this.query, this.returning);
            Sinks.EmitResult result = this.requests.tryEmitNext((Object)message);
            if (result == Sinks.EmitResult.OK) {
                return;
            }
            QueryFlow.logger.error("Emit request failed due to {}", (Object)result);
            message.dispose();
        }
        if (sink != null) {
            sink.complete();
        }
    }

    @Override
    protected String offendingSql() {
        return StringUtils.extendReturning(this.query.getFormattedSql(), this.returning);
    }
}

