/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.InitFlow;
import io.asyncer.r2dbc.mysql.MySqlConnectionConfiguration;
import io.asyncer.r2dbc.mysql.MySqlConnectionFactoryMetadata;
import io.asyncer.r2dbc.mysql.MySqlSimpleConnection;
import io.asyncer.r2dbc.mysql.MySqlSslConfiguration;
import io.asyncer.r2dbc.mysql.api.MySqlConnection;
import io.asyncer.r2dbc.mysql.cache.Caches;
import io.asyncer.r2dbc.mysql.cache.QueryCache;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.netty.channel.unix.DomainSocketAddress;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class MySqlConnectionFactory
implements ConnectionFactory {
    private final Mono<? extends MySqlConnection> client;

    private MySqlConnectionFactory(Mono<? extends MySqlConnection> client) {
        this.client = client;
    }

    public Mono<? extends MySqlConnection> create() {
        return this.client;
    }

    public ConnectionFactoryMetadata getMetadata() {
        return MySqlConnectionFactoryMetadata.INSTANCE;
    }

    public static MySqlConnectionFactory from(MySqlConnectionConfiguration configuration) {
        AssertUtils.requireNonNull(configuration, "configuration must not be null");
        LazyQueryCache queryCache = new LazyQueryCache(configuration.getQueryCacheSize());
        return new MySqlConnectionFactory((Mono<? extends MySqlConnection>)Mono.defer(() -> {
            Object address;
            MySqlSslConfiguration ssl;
            if (configuration.isHost()) {
                ssl = configuration.getSsl();
                address = InetSocketAddress.createUnresolved(configuration.getDomain(), configuration.getPort());
            } else {
                ssl = MySqlSslConfiguration.disabled();
                address = new DomainSocketAddress(configuration.getDomain());
            }
            String user = configuration.getUser();
            CharSequence password = configuration.getPassword();
            Publisher<String> passwordPublisher = configuration.getPasswordPublisher();
            if (Objects.nonNull(passwordPublisher)) {
                return Mono.from(passwordPublisher).flatMap(arg_0 -> MySqlConnectionFactory.lambda$null$0(configuration, ssl, queryCache, (SocketAddress)address, user, arg_0));
            }
            return MySqlConnectionFactory.getMySqlConnection(configuration, ssl, queryCache, (SocketAddress)address, user, password);
        }));
    }

    private static Mono<MySqlConnection> getMySqlConnection(MySqlConnectionConfiguration configuration, MySqlSslConfiguration ssl, LazyQueryCache queryCache, SocketAddress address, String user, @Nullable CharSequence password) {
        return Mono.fromSupplier(() -> {
            ZoneId connectionTimeZone = MySqlConnectionFactory.retrieveZoneId(configuration.getConnectionTimeZone());
            return new ConnectionContext(configuration.getZeroDateOption(), configuration.getLoadLocalInfilePath(), configuration.getLocalInfileBufferSize(), configuration.isPreserveInstants(), connectionTimeZone);
        }).flatMap(context -> Client.connect(ssl, address, configuration.isTcpKeepAlive(), configuration.isTcpNoDelay(), context, configuration.getConnectTimeout(), configuration.getLoopResources())).flatMap(client -> {
            boolean deferDatabase = configuration.isCreateDatabaseIfNotExist();
            String database = configuration.getDatabase();
            String loginDb = deferDatabase ? "" : database;
            String sessionDb = deferDatabase ? database : "";
            return InitFlow.initHandshake(client, ssl.getSslMode(), loginDb, user, password, configuration.getCompressionAlgorithms(), configuration.getZstdCompressionLevel()).then(InitFlow.initSession(client, sessionDb, configuration.getPrepareCacheSize(), configuration.getSessionVariables(), configuration.isForceConnectionTimeZoneToSession(), configuration.getLockWaitTimeout(), configuration.getStatementTimeout(), configuration.getExtensions())).map(codecs -> new MySqlSimpleConnection((Client)client, (Codecs)codecs, queryCache.get(), configuration.getPreferPrepareStatement())).onErrorResume(e -> client.forceClose().then(Mono.error((Throwable)e)));
        });
    }

    @Nullable
    private static ZoneId retrieveZoneId(String timeZone) {
        if ("LOCAL".equalsIgnoreCase(timeZone)) {
            return ZoneId.systemDefault().normalized();
        }
        if ("SERVER".equalsIgnoreCase(timeZone)) {
            return null;
        }
        return StringUtils.parseZoneId(timeZone);
    }

    private static /* synthetic */ Mono lambda$null$0(MySqlConnectionConfiguration configuration, MySqlSslConfiguration ssl, LazyQueryCache queryCache, SocketAddress address, String user, String token) {
        return MySqlConnectionFactory.getMySqlConnection(configuration, ssl, queryCache, address, user, token);
    }

    private static final class LazyQueryCache
    implements Supplier<QueryCache> {
        private final int capacity;
        private final ReentrantLock lock = new ReentrantLock();
        @Nullable
        private volatile QueryCache cache;

        private LazyQueryCache(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public QueryCache get() {
            QueryCache cache = this.cache;
            if (cache == null) {
                this.lock.lock();
                try {
                    cache = this.cache;
                    if (cache == null) {
                        this.cache = cache = Caches.createQueryCache(this.capacity);
                    }
                    QueryCache queryCache = cache;
                    return queryCache;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return cache;
        }
    }
}

