/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.message.server.CompleteMessage;
import io.asyncer.r2dbc.mysql.message.server.ErrorMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.SynchronousSink;

abstract class AbstractTransactionState {
    final Client client;
    final List<String> statements = new ArrayList<String>(5);
    int tasks;
    @Nullable
    private String sql;

    protected AbstractTransactionState(Client client) {
        this.client = client;
    }

    final void setSql(String sql) {
        this.sql = sql;
    }

    final String batchStatement() {
        if (this.statements.size() == 1) {
            return this.statements.get(0);
        }
        return String.join((CharSequence)";", this.statements);
    }

    final Iterator<String> statements() {
        return this.statements.iterator();
    }

    final boolean accept(ServerMessage message, SynchronousSink<Void> sink) {
        if (message instanceof ErrorMessage) {
            sink.error((Throwable)((ErrorMessage)message).toException(this.sql));
            return false;
        }
        if (message instanceof CompleteMessage) {
            int task = Integer.lowestOneBit(this.tasks);
            this.tasks -= task;
            return this.process(task, sink);
        }
        if (message instanceof ReferenceCounted) {
            ReferenceCountUtil.safeRelease((Object)message);
        }
        return false;
    }

    abstract boolean cancelTasks();

    protected abstract boolean process(int var1, SynchronousSink<Void> var2);
}

