/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.AbstractTransactionState;
import io.asyncer.r2dbc.mysql.ConnectionState;
import io.asyncer.r2dbc.mysql.ConsistentSnapshotEngine;
import io.asyncer.r2dbc.mysql.MySqlTransactionDefinition;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.TransactionDefinition;
import java.time.Duration;
import reactor.core.publisher.SynchronousSink;

final class StartTransactionState
extends AbstractTransactionState {
    private static final int LOCK_WAIT_TIMEOUT = 1;
    private static final int ISOLATION_LEVEL = 2;
    private static final int START_TRANSACTION = 4;
    private static final int CANCEL = 8;
    private final TransactionDefinition definition;

    StartTransactionState(ConnectionState state, TransactionDefinition definition) {
        super(state);
        this.definition = definition;
    }

    @Override
    boolean cancelTasks() {
        IsolationLevel isolationLevel;
        if (this.state.isInTransaction()) {
            this.tasks |= 8;
            return true;
        }
        Duration timeout = (Duration)this.definition.getAttribute(TransactionDefinition.LOCK_WAIT_TIMEOUT);
        if (timeout != null) {
            long lockWaitTimeout = timeout.getSeconds();
            this.tasks |= 1;
            this.statements.add("SET innodb_lock_wait_timeout=" + lockWaitTimeout);
        }
        if ((isolationLevel = (IsolationLevel)this.definition.getAttribute(TransactionDefinition.ISOLATION_LEVEL)) != null) {
            this.statements.add("SET TRANSACTION ISOLATION LEVEL " + isolationLevel.asSql());
            this.tasks |= 2;
        }
        this.tasks |= 4;
        this.statements.add(StartTransactionState.buildStartTransaction(this.definition));
        return false;
    }

    @Override
    protected boolean process(int task, SynchronousSink<Void> sink) {
        switch (task) {
            case 1: {
                Duration timeout = (Duration)this.definition.getAttribute(TransactionDefinition.LOCK_WAIT_TIMEOUT);
                if (timeout != null) {
                    long lockWaitTimeout = timeout.getSeconds();
                    this.state.setCurrentLockWaitTimeout(lockWaitTimeout);
                }
                return true;
            }
            case 2: {
                IsolationLevel isolationLevel = (IsolationLevel)this.definition.getAttribute(TransactionDefinition.ISOLATION_LEVEL);
                if (isolationLevel != null) {
                    this.state.setIsolationLevel(isolationLevel);
                }
                return true;
            }
            case 4: 
            case 8: {
                sink.complete();
                return false;
            }
        }
        sink.error((Throwable)new IllegalStateException("Undefined transaction task: " + task + ", remain: " + this.tasks));
        return false;
    }

    private static String buildStartTransaction(TransactionDefinition definition) {
        Boolean readOnly = (Boolean)definition.getAttribute(TransactionDefinition.READ_ONLY);
        Boolean snapshot = (Boolean)definition.getAttribute(MySqlTransactionDefinition.WITH_CONSISTENT_SNAPSHOT);
        if (!(readOnly != null || snapshot != null && snapshot.booleanValue())) {
            return "BEGIN";
        }
        StringBuilder builder = new StringBuilder(90).append("START TRANSACTION");
        if (snapshot != null && snapshot.booleanValue()) {
            ConsistentSnapshotEngine engine = (ConsistentSnapshotEngine)((Object)definition.getAttribute(MySqlTransactionDefinition.CONSISTENT_SNAPSHOT_ENGINE));
            builder.append(" WITH CONSISTENT ");
            if (engine == null) {
                builder.append("SNAPSHOT");
            } else {
                builder.append(engine.asSql()).append(" SNAPSHOT");
            }
            Long sessionId = (Long)definition.getAttribute(MySqlTransactionDefinition.CONSISTENT_SNAPSHOT_FROM_SESSION);
            if (sessionId != null) {
                builder.append(" FROM SESSION ").append(Long.toUnsignedString(sessionId));
            }
        }
        if (readOnly != null) {
            if (readOnly.booleanValue()) {
                builder.append(" READ ONLY");
            } else {
                builder.append(" READ WRITE");
            }
        }
        return builder.toString();
    }
}

