/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.DateTimes;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.LocalDate;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

final class LocalDateCodec
extends AbstractClassedCodec<LocalDate> {
    static final LocalDate ROUND = LocalDate.of(1, 1, 1);

    LocalDateCodec(ByteBufAllocator allocator) {
        super(allocator, LocalDate.class);
    }

    @Override
    public LocalDate decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        LocalDate date;
        int bytes = value.readableBytes();
        LocalDate localDate = date = binary ? LocalDateCodec.readDateBinary(value, bytes) : LocalDateCodec.readDateText(value);
        if (date != null) {
            return date;
        }
        return DateTimes.zeroDate(context.getZeroDateOption(), binary, ROUND);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalDate;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new LocalDateMySqlParameter(this.allocator, (LocalDate)value);
    }

    @Override
    public boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType() == MySqlType.DATE;
    }

    @Nullable
    static LocalDate readDateText(ByteBuf buf) {
        int year = DateTimes.readIntInDigits(buf);
        int month = DateTimes.readIntInDigits(buf);
        int day = DateTimes.readIntInDigits(buf);
        if (month == 0 || day == 0) {
            return null;
        }
        return LocalDate.of(year, month, day);
    }

    @Nullable
    static LocalDate readDateBinary(ByteBuf buf, int bytes) {
        if (bytes < 4) {
            return null;
        }
        short year = buf.readShortLE();
        byte month = buf.readByte();
        byte day = buf.readByte();
        if (month == 0 || day == 0) {
            return null;
        }
        return LocalDate.of((int)year, month, (int)day);
    }

    static ByteBuf encodeDate(ByteBufAllocator alloc, LocalDate date) {
        ByteBuf buf = alloc.buffer(5);
        try {
            return buf.writeByte(4).writeShortLE(date.getYear()).writeByte(date.getMonthValue()).writeByte(date.getDayOfMonth());
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    static void encodeDate(ParameterWriter writer, LocalDate date) {
        boolean isNegative;
        int year = date.getYear();
        if (year < 0) {
            year = -year;
            isNegative = true;
        } else {
            isNegative = false;
        }
        if (isNegative) {
            writer.append('-');
        } else {
            writer.startString();
        }
        if (year < 1000) {
            writer.append('0');
            if (year < 100) {
                writer.append('0');
                if (year < 10) {
                    writer.append('0');
                }
            }
        }
        writer.writeInt(year);
        writer.append('-');
        int month = date.getMonthValue();
        if (month < 10) {
            writer.append('0');
        }
        writer.writeInt(month);
        writer.append('-');
        int day = date.getDayOfMonth();
        if (day < 10) {
            writer.append('0');
        }
        writer.writeInt(day);
    }

    private static final class LocalDateMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final LocalDate value;

        private LocalDateMySqlParameter(ByteBufAllocator allocator, LocalDate value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> LocalDateCodec.encodeDate(this.allocator, this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalDateCodec.encodeDate(writer, this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.DATE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalDateMySqlParameter)) {
                return false;
            }
            LocalDateMySqlParameter that = (LocalDateMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

