/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import io.astefanutti.metrics.aspectj.AbstractMetricAspect;
import io.astefanutti.metrics.aspectj.AnnotatedMetric;
import io.astefanutti.metrics.aspectj.MetricStrategy;
import io.astefanutti.metrics.aspectj.MetricStrategyFactory;
import io.astefanutti.metrics.aspectj.Metrics;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public final class MetricStaticAspect
extends AbstractMetricAspect {
    static final Map<String, AnnotatedMetric<Gauge>> GAUGES;
    static final Map<String, AnnotatedMetric<Meter>> METERS;
    static final Map<String, AnnotatedMetric<Timer>> TIMERS;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MetricStaticAspect ajc$perSingletonInstance;

    static {
        try {
            GAUGES = new ConcurrentHashMap<String, AnnotatedMetric<Gauge>>();
            METERS = new ConcurrentHashMap<String, AnnotatedMetric<Meter>>();
            TIMERS = new ConcurrentHashMap<String, AnnotatedMetric<Timer>>();
            MetricStaticAspect.ajc$perSingletonInstance = new MetricStaticAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    MetricStaticAspect() {
    }

    @Pointcut(value="staticinitialization((@io.astefanutti.metrics.aspectj.Metrics *).<clinit>())", argNames="")
    /* synthetic */ void ajc$pointcut$$profiled$646() {
    }

    @After(value="profiled()", argNames="")
    public void ajc$after$io_astefanutti_metrics_aspectj_MetricStaticAspect$1$be47261c(JoinPoint.StaticPart thisJoinPointStaticPart) {
        Class clazz = thisJoinPointStaticPart.getSignature().getDeclaringType();
        MetricStrategy strategy = MetricStrategyFactory.newInstance(clazz);
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isStatic(method.getModifiers()) && !method.isSynthetic()) {
                AnnotatedMetric<Timer> timer;
                AnnotatedMetric<Meter> meter;
                AnnotatedMetric<Gauge> gauge;
                AnnotatedMetric<Meter> exception = this.metricAnnotation(method, ExceptionMetered.class, new AbstractMetricAspect.MetricFactory<Meter>(this, method, strategy, clazz){
                    final /* synthetic */ MetricStaticAspect this$0;
                    private final /* synthetic */ Method val$method;
                    private final /* synthetic */ MetricStrategy val$strategy;
                    private final /* synthetic */ Class val$clazz;
                    {
                        this.this$0 = metricStaticAspect;
                        this.val$method = method;
                        this.val$strategy = metricStrategy;
                        this.val$clazz = clazz;
                    }

                    public Meter metric(String name, boolean absolute) {
                        String finalName = name.isEmpty() ? String.valueOf(this.val$method.getName()) + "." + "exceptions" : this.val$strategy.resolveMetricName(name);
                        MetricRegistry registry = this.val$strategy.resolveMetricRegistry(this.val$clazz.getAnnotation(Metrics.class).registry());
                        return registry.meter(absolute ? finalName : MetricRegistry.name((Class)this.val$clazz, (String[])new String[]{finalName}));
                    }
                });
                if (exception.isPresent()) {
                    METERS.put(method.toString(), exception);
                }
                if ((gauge = this.metricAnnotation(method, com.codahale.metrics.annotation.Gauge.class, new AbstractMetricAspect.MetricFactory<Gauge>(this, method, strategy, clazz){
                    final /* synthetic */ MetricStaticAspect this$0;
                    private final /* synthetic */ Method val$method;
                    private final /* synthetic */ MetricStrategy val$strategy;
                    private final /* synthetic */ Class val$clazz;
                    {
                        this.this$0 = metricStaticAspect;
                        this.val$method = method;
                        this.val$strategy = metricStrategy;
                        this.val$clazz = clazz;
                    }

                    public Gauge metric(String name, boolean absolute) {
                        String finalName = name.isEmpty() ? this.val$method.getName() : this.val$strategy.resolveMetricName(name);
                        MetricRegistry registry = this.val$strategy.resolveMetricRegistry(this.val$clazz.getAnnotation(Metrics.class).registry());
                        return (Gauge)registry.register(absolute ? finalName : MetricRegistry.name((Class)this.val$clazz, (String[])new String[]{finalName}), (Metric)new AbstractMetricAspect.ForwardingGauge(this.val$method, this.val$clazz));
                    }
                })).isPresent()) {
                    GAUGES.put(method.toString(), gauge);
                }
                if ((meter = this.metricAnnotation(method, Metered.class, new AbstractMetricAspect.MetricFactory<Meter>(this, method, strategy, clazz){
                    final /* synthetic */ MetricStaticAspect this$0;
                    private final /* synthetic */ Method val$method;
                    private final /* synthetic */ MetricStrategy val$strategy;
                    private final /* synthetic */ Class val$clazz;
                    {
                        this.this$0 = metricStaticAspect;
                        this.val$method = method;
                        this.val$strategy = metricStrategy;
                        this.val$clazz = clazz;
                    }

                    public Meter metric(String name, boolean absolute) {
                        String finalName = name.isEmpty() ? this.val$method.getName() : this.val$strategy.resolveMetricName(name);
                        MetricRegistry registry = this.val$strategy.resolveMetricRegistry(this.val$clazz.getAnnotation(Metrics.class).registry());
                        return registry.meter(absolute ? finalName : MetricRegistry.name((Class)this.val$clazz, (String[])new String[]{finalName}));
                    }
                })).isPresent()) {
                    METERS.put(method.toString(), meter);
                }
                if ((timer = this.metricAnnotation(method, Timed.class, new AbstractMetricAspect.MetricFactory<Timer>(this, method, strategy, clazz){
                    final /* synthetic */ MetricStaticAspect this$0;
                    private final /* synthetic */ Method val$method;
                    private final /* synthetic */ MetricStrategy val$strategy;
                    private final /* synthetic */ Class val$clazz;
                    {
                        this.this$0 = metricStaticAspect;
                        this.val$method = method;
                        this.val$strategy = metricStrategy;
                        this.val$clazz = clazz;
                    }

                    public Timer metric(String name, boolean absolute) {
                        String finalName = name.isEmpty() ? this.val$method.getName() : this.val$strategy.resolveMetricName(name);
                        MetricRegistry registry = this.val$strategy.resolveMetricRegistry(this.val$clazz.getAnnotation(Metrics.class).registry());
                        return registry.timer(absolute ? finalName : MetricRegistry.name((Class)this.val$clazz, (String[])new String[]{finalName}));
                    }
                })).isPresent()) {
                    TIMERS.put(method.toString(), timer);
                }
            }
            ++n2;
        }
    }

    public static MetricStaticAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io_astefanutti_metrics_aspectj_MetricStaticAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

