/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj;

import io.astefanutti.metrics.aspectj.JavaSeMetricStrategy;
import io.astefanutti.metrics.aspectj.JavaxElMetricStrategy;
import io.astefanutti.metrics.aspectj.MetricStrategy;

final class MetricStrategyFactory {
    MetricStrategyFactory() {
    }

    static MetricStrategy newInstance(Object object) {
        if (MetricStrategyFactory.isElAvailable(object.getClass())) {
            return new JavaxElMetricStrategy(object);
        }
        return new JavaSeMetricStrategy();
    }

    static MetricStrategy newInstance(Class<?> clazz) {
        if (MetricStrategyFactory.isElAvailable(clazz)) {
            return new JavaxElMetricStrategy(clazz);
        }
        return new JavaSeMetricStrategy();
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return clazz.getClassLoader();
    }

    private static boolean isElAvailable(Class<?> clazz) {
        try {
            MetricStrategyFactory.getClassLoader(clazz).loadClass("javax.el.ELProcessor");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

