/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumExecutionMethod;
import io.appium.java_client.ComparesImages;
import io.appium.java_client.DefaultGenericMobileDriver;
import io.appium.java_client.ErrorCodesMobile;
import io.appium.java_client.FindsByCustom;
import io.appium.java_client.FindsByImage;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.NoSuchContextException;
import io.appium.java_client.internal.JsonToMobileElementConverter;
import io.appium.java_client.remote.AppiumCommandExecutor;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.DeviceRotation;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.http.HttpClient;

public class AppiumDriver<T extends WebElement>
extends DefaultGenericMobileDriver<T>
implements ComparesImages,
FindsByImage<T>,
FindsByCustom<T> {
    private static final ErrorHandler errorHandler = new ErrorHandler((ErrorCodes)new ErrorCodesMobile(), true);
    private URL remoteAddress;
    private RemoteLocationContext locationContext;
    private ExecuteMethod executeMethod = new AppiumExecutionMethod(this);

    public AppiumDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super((CommandExecutor)executor, capabilities);
        this.locationContext = new RemoteLocationContext(this.executeMethod);
        super.setErrorHandler(errorHandler);
        this.remoteAddress = executor.getAddressOfRemoteServer();
        this.setElementConverter(new JsonToMobileElementConverter(this, this));
    }

    public AppiumDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress), desiredCapabilities);
    }

    public AppiumDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress, httpClientFactory), desiredCapabilities);
    }

    public AppiumDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, service), desiredCapabilities);
    }

    public AppiumDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, service, httpClientFactory), desiredCapabilities);
    }

    public AppiumDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        this((AppiumDriverLocalService)builder.build(), desiredCapabilities);
    }

    public AppiumDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        this((AppiumDriverLocalService)builder.build(), httpClientFactory, desiredCapabilities);
    }

    public AppiumDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        this(AppiumDriverLocalService.buildDefaultService(), httpClientFactory, desiredCapabilities);
    }

    public AppiumDriver(Capabilities desiredCapabilities) {
        this(AppiumDriverLocalService.buildDefaultService(), desiredCapabilities);
    }

    protected static Capabilities substituteMobilePlatform(Capabilities originalCapabilities, String newPlatform) {
        DesiredCapabilities dc = new DesiredCapabilities(originalCapabilities);
        dc.setCapability("platformName", newPlatform);
        return dc;
    }

    @Override
    public List<T> findElements(By by) {
        return super.findElements(by);
    }

    @Override
    public List<T> findElements(String by, String using) {
        return super.findElements(by, using);
    }

    @Override
    public List<T> findElementsById(String id) {
        return super.findElementsById(id);
    }

    @Override
    public List<T> findElementsByLinkText(String using) {
        return super.findElementsByLinkText(using);
    }

    @Override
    public List<T> findElementsByPartialLinkText(String using) {
        return super.findElementsByPartialLinkText(using);
    }

    @Override
    public List<T> findElementsByTagName(String using) {
        return super.findElementsByTagName(using);
    }

    @Override
    public List<T> findElementsByName(String using) {
        return super.findElementsByName(using);
    }

    @Override
    public List<T> findElementsByClassName(String using) {
        return super.findElementsByClassName(using);
    }

    @Override
    public List<T> findElementsByCssSelector(String using) {
        return super.findElementsByCssSelector(using);
    }

    @Override
    public List<T> findElementsByXPath(String using) {
        return super.findElementsByXPath(using);
    }

    @Override
    public List<T> findElementsByAccessibilityId(String using) {
        return super.findElementsByAccessibilityId(using);
    }

    public ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    public WebDriver context(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Must supply a context name");
        try {
            this.execute("switchToContext", (Map)ImmutableMap.of((Object)"name", (Object)name));
            return this;
        }
        catch (WebDriverException e) {
            throw new NoSuchContextException(e.getMessage(), e);
        }
    }

    public Set<String> getContextHandles() {
        Response response = this.execute("getContextHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public String getContext() {
        String contextName = String.valueOf(this.execute("getCurrentContextHandle").getValue());
        if ("null".equalsIgnoreCase(contextName)) {
            return null;
        }
        return contextName;
    }

    public DeviceRotation rotation() {
        Response response = this.execute("getScreenRotation");
        DeviceRotation deviceRotation = new DeviceRotation((Map)response.getValue());
        if (deviceRotation.getX() < 0 || deviceRotation.getY() < 0 || deviceRotation.getZ() < 0) {
            throw new WebDriverException("Unexpected orientation returned: " + deviceRotation);
        }
        return deviceRotation;
    }

    public void rotate(DeviceRotation rotation) {
        this.execute("setScreenRotation", rotation.parameters());
    }

    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", (Map)ImmutableMap.of((Object)"orientation", (Object)orientation.value().toUpperCase()));
    }

    public ScreenOrientation getOrientation() {
        Response response = this.execute("getScreenOrientation");
        String orientation = response.getValue().toString().toLowerCase();
        if (orientation.equals(ScreenOrientation.LANDSCAPE.value())) {
            return ScreenOrientation.LANDSCAPE;
        }
        if (orientation.equals(ScreenOrientation.PORTRAIT.value())) {
            return ScreenOrientation.PORTRAIT;
        }
        throw new WebDriverException("Unexpected orientation returned: " + orientation);
    }

    public Location location() {
        return this.locationContext.location();
    }

    public void setLocation(Location location) {
        this.locationContext.setLocation(location);
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public boolean isBrowser() {
        return super.isBrowser() && !StringUtils.containsIgnoreCase((CharSequence)this.getContext(), (CharSequence)"NATIVE_APP");
    }
}

