/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.ApacheHttpClient;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumCommandExecutor
extends HttpCommandExecutor {
    private final Optional<DriverService> serviceOptional;

    private AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        super(additionalCommands, Optional.ofNullable(service).map(DriverService::getUrl).orElse(addressOfRemoteServer), httpClientFactory);
        this.serviceOptional = Optional.ofNullable(service);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, (DriverService)Preconditions.checkNotNull((Object)service), null, httpClientFactory);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, null, (URL)Preconditions.checkNotNull((Object)addressOfRemoteServer), httpClientFactory);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, addressOfRemoteServer, (HttpClient.Factory)new ApacheHttpClient.Factory());
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service) {
        this(additionalCommands, service, (HttpClient.Factory)new ApacheHttpClient.Factory());
    }

    public Response execute(Command command) throws WebDriverException {
        if ("newSession".equals(command.getName())) {
            this.serviceOptional.ifPresent(driverService -> {
                try {
                    driverService.start();
                }
                catch (IOException e) {
                    throw new WebDriverException(e.getMessage(), (Throwable)e);
                }
            });
        }
        try {
            Response response = super.execute(command);
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused")) {
                throw this.serviceOptional.map(service -> {
                    if (service.isRunning()) {
                        return new WebDriverException("The session is closed!", rootCause);
                    }
                    return new WebDriverException("The appium server has accidentally died!", rootCause);
                }).orElseGet((java.util.function.Supplier<WebDriverException>)((Supplier)() -> new WebDriverException(rootCause.getMessage(), rootCause)));
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new WebDriverException(t);
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.serviceOptional.ifPresent(DriverService::stop);
            }
        }
    }
}

