/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.appium.java_client.AppiumExecutionMethod;
import io.appium.java_client.AppiumSetting;
import io.appium.java_client.DefaultGenericMobileDriver;
import io.appium.java_client.ErrorCodesMobile;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.TouchAction;
import io.appium.java_client.remote.AppiumCommandExecutor;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

public abstract class AppiumDriver<T extends WebElement>
extends DefaultGenericMobileDriver<T> {
    private static final ErrorHandler errorHandler = new ErrorHandler((ErrorCodes)new ErrorCodesMobile(), true);
    private URL remoteAddress;
    private RemoteLocationContext locationContext;
    private ExecuteMethod executeMethod = new AppiumExecutionMethod(this);

    protected AppiumDriver(HttpCommandExecutor executor, Capabilities capabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        super((CommandExecutor)executor, capabilities);
        this.locationContext = new RemoteLocationContext(this.executeMethod);
        super.setErrorHandler(errorHandler);
        this.remoteAddress = executor.getAddressOfRemoteServer();
        try {
            Constructor<? extends JsonToWebElementConverter> constructor = converterClazz.getConstructor(RemoteWebDriver.class);
            this.setElementConverter(constructor.newInstance(this));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public AppiumDriver(URL remoteAddress, Capabilities desiredCapabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress), desiredCapabilities, converterClazz);
    }

    public AppiumDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress, httpClientFactory), desiredCapabilities, converterClazz);
    }

    public AppiumDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, service), desiredCapabilities, converterClazz);
    }

    public AppiumDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, service, httpClientFactory), desiredCapabilities, converterClazz);
    }

    public AppiumDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        this((AppiumDriverLocalService)builder.build(), desiredCapabilities, converterClazz);
    }

    public AppiumDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        this((AppiumDriverLocalService)builder.build(), httpClientFactory, desiredCapabilities, converterClazz);
    }

    public AppiumDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        this(AppiumDriverLocalService.buildDefaultService(), httpClientFactory, desiredCapabilities, converterClazz);
    }

    public AppiumDriver(Capabilities desiredCapabilities, Class<? extends JsonToWebElementConverter> converterClazz) {
        this(AppiumDriverLocalService.buildDefaultService(), desiredCapabilities, converterClazz);
    }

    protected static Capabilities substituteMobilePlatform(Capabilities originalCapabilities, String newPlatform) {
        DesiredCapabilities dc = new DesiredCapabilities(originalCapabilities);
        dc.setCapability("platformName", newPlatform);
        return dc;
    }

    protected static ImmutableMap<String, Object> getCommandImmutableMap(String param, Object value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)param, value);
        return builder.build();
    }

    protected static ImmutableMap<String, Object> getCommandImmutableMap(String[] params, Object[] values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int i = 0;
        while (i < params.length) {
            if (!StringUtils.isBlank((CharSequence)params[i]) && values[i] != null) {
                builder.put((Object)params[i], values[i]);
            }
            ++i;
        }
        return builder.build();
    }

    private static CommandInfo deleteC(String url) {
        return new CommandInfo(url, HttpMethod.DELETE);
    }

    @Override
    public List<T> findElements(By by) {
        return super.findElements(by);
    }

    @Override
    public List<T> findElements(String by, String using) {
        return super.findElements(by, using);
    }

    @Override
    public List<T> findElementsById(String id) {
        return super.findElementsById(id);
    }

    @Override
    public List<T> findElementsByLinkText(String using) {
        return super.findElementsByLinkText(using);
    }

    @Override
    public List<T> findElementsByPartialLinkText(String using) {
        return super.findElementsByPartialLinkText(using);
    }

    @Override
    public List<T> findElementsByTagName(String using) {
        return super.findElementsByTagName(using);
    }

    @Override
    public List<T> findElementsByName(String using) {
        return super.findElementsByName(using);
    }

    @Override
    public List<T> findElementsByClassName(String using) {
        return super.findElementsByClassName(using);
    }

    @Override
    public List<T> findElementsByCssSelector(String using) {
        return super.findElementsByCssSelector(using);
    }

    @Override
    public List<T> findElementsByXPath(String using) {
        return super.findElementsByXPath(using);
    }

    @Override
    public List<T> findElementsByAccessibilityId(String using) {
        return this.findElements("accessibility id", using);
    }

    protected Response execute(String command) {
        return super.execute(command, (Map<String, ?>)ImmutableMap.of());
    }

    public ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    @Override
    public void resetApp() {
        this.execute("reset");
    }

    @Override
    public boolean isAppInstalled(String bundleId) {
        Response response = this.execute("isAppInstalled", (Map)ImmutableMap.of((Object)"bundleId", (Object)bundleId));
        return Boolean.parseBoolean(response.getValue().toString());
    }

    @Override
    public void installApp(String appPath) {
        this.execute("installApp", (Map)ImmutableMap.of((Object)"appPath", (Object)appPath));
    }

    @Override
    public void removeApp(String bundleId) {
        this.execute("removeApp", (Map)ImmutableMap.of((Object)"bundleId", (Object)bundleId));
    }

    @Override
    public void launchApp() {
        this.execute("launchApp");
    }

    @Override
    public void closeApp() {
        this.execute("closeApp");
    }

    @Override
    public void runAppInBackground(int seconds) {
        this.execute("runAppInBackground", (Map)ImmutableMap.of((Object)"seconds", (Object)seconds));
    }

    @Override
    public String getDeviceTime() {
        Response response = this.execute("getDeviceTime");
        return response.getValue().toString();
    }

    @Override
    public void hideKeyboard() {
        this.execute("hideKeyboard");
    }

    @Override
    public byte[] pullFile(String remotePath) {
        Response response = this.execute("pullFile", (Map)ImmutableMap.of((Object)"path", (Object)remotePath));
        String base64String = response.getValue().toString();
        return DatatypeConverter.parseBase64Binary((String)base64String);
    }

    @Override
    public byte[] pullFolder(String remotePath) {
        Response response = this.execute("pullFolder", (Map)ImmutableMap.of((Object)"path", (Object)remotePath));
        String base64String = response.getValue().toString();
        return DatatypeConverter.parseBase64Binary((String)base64String);
    }

    @Override
    public TouchAction performTouchAction(TouchAction touchAction) {
        ImmutableMap<String, ImmutableList> parameters = touchAction.getParameters();
        this.execute("performTouchAction", (Map)parameters);
        return touchAction;
    }

    @Override
    public void performMultiTouchAction(MultiTouchAction multiAction) {
        ImmutableMap parameters = multiAction.getParameters();
        this.execute("performMultiTouch", (Map)parameters);
    }

    @Override
    public void tap(int fingers, WebElement element, int duration) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int i = 0;
        while (i < fingers) {
            multiTouch.add(this.createTap(element, duration));
            ++i;
        }
        multiTouch.perform();
    }

    @Override
    public void tap(int fingers, int x, int y, int duration) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int i = 0;
        while (i < fingers) {
            multiTouch.add(this.createTap(x, y, duration));
            ++i;
        }
        multiTouch.perform();
    }

    protected void doSwipe(int startx, int starty, int endx, int endy, int duration) {
        TouchAction touchAction = new TouchAction(this);
        touchAction.press(startx, starty).waitAction(duration).moveTo(endx, endy).release();
        touchAction.perform();
    }

    @Override
    public abstract void swipe(int var1, int var2, int var3, int var4, int var5);

    @Override
    public void pinch(WebElement el) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        Dimension dimensions = el.getSize();
        Point upperLeft = el.getLocation();
        Point center = new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
        int yOffset = center.getY() - upperLeft.getY();
        TouchAction action0 = new TouchAction(this).press(el, center.getX(), center.getY() - yOffset).moveTo(el).release();
        TouchAction action1 = new TouchAction(this).press(el, center.getX(), center.getY() + yOffset).moveTo(el).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    @Override
    public void pinch(int x, int y) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int scrHeight = this.manage().window().getSize().getHeight();
        int yOffset = 100;
        if (y - 100 < 0) {
            yOffset = y;
        } else if (y + 100 > scrHeight) {
            yOffset = scrHeight - y;
        }
        TouchAction action0 = new TouchAction(this).press(x, y - yOffset).moveTo(x, y).release();
        TouchAction action1 = new TouchAction(this).press(x, y + yOffset).moveTo(x, y).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    @Override
    public void zoom(WebElement el) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        Dimension dimensions = el.getSize();
        Point upperLeft = el.getLocation();
        Point center = new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
        int yOffset = center.getY() - upperLeft.getY();
        TouchAction action0 = new TouchAction(this).press(center.getX(), center.getY()).moveTo(el, center.getX(), center.getY() - yOffset).release();
        TouchAction action1 = new TouchAction(this).press(center.getX(), center.getY()).moveTo(el, center.getX(), center.getY() + yOffset).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    @Override
    public void zoom(int x, int y) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int scrHeight = this.manage().window().getSize().getHeight();
        int yOffset = 100;
        if (y - 100 < 0) {
            yOffset = y;
        } else if (y + 100 > scrHeight) {
            yOffset = scrHeight - y;
        }
        TouchAction action0 = new TouchAction(this).press(x, y).moveTo(0, -yOffset).release();
        TouchAction action1 = new TouchAction(this).press(x, y).moveTo(0, yOffset).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    public JsonObject getSettings() {
        Response response = this.execute("getSettings");
        JsonParser parser = new JsonParser();
        return (JsonObject)parser.parse(response.getValue().toString());
    }

    private void setSettings(ImmutableMap<?, ?> settings) {
        this.execute("setSettings", (Map)AppiumDriver.getCommandImmutableMap("settings", settings));
    }

    protected void setSetting(AppiumSetting setting, Object value) {
        this.setSettings(AppiumDriver.getCommandImmutableMap(setting.toString(), value));
    }

    public WebDriver context(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Must supply a context name");
        this.execute("switchToContext", (Map)ImmutableMap.of((Object)"name", (Object)name));
        return this;
    }

    public Set<String> getContextHandles() {
        Response response = this.execute("getContextHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public String getContext() {
        String contextName = String.valueOf(this.execute("getCurrentContextHandle").getValue());
        if (contextName.equals("null")) {
            return null;
        }
        return contextName;
    }

    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", (Map)ImmutableMap.of((Object)"orientation", (Object)orientation.value().toUpperCase()));
    }

    public ScreenOrientation getOrientation() {
        Response response = this.execute("getScreenOrientation");
        String orientation = response.getValue().toString().toLowerCase();
        if (orientation.equals(ScreenOrientation.LANDSCAPE.value())) {
            return ScreenOrientation.LANDSCAPE;
        }
        if (orientation.equals(ScreenOrientation.PORTRAIT.value())) {
            return ScreenOrientation.PORTRAIT;
        }
        throw new WebDriverException("Unexpected orientation returned: " + orientation);
    }

    public Location location() {
        return this.locationContext.location();
    }

    public void setLocation(Location location) {
        this.locationContext.setLocation(location);
    }

    @Override
    public Map<String, String> getAppStringMap() {
        Response response = this.execute("getStrings");
        return (Map)response.getValue();
    }

    @Override
    public Map<String, String> getAppStringMap(String language) {
        Response response = this.execute("getStrings", (Map)AppiumDriver.getCommandImmutableMap("language", language));
        return (Map)response.getValue();
    }

    @Override
    public Map<String, String> getAppStringMap(String language, String stringFile) {
        String[] parameters = new String[]{"language", "stringFile"};
        Object[] values = new Object[]{language, stringFile};
        Response response = this.execute("getStrings", (Map)AppiumDriver.getCommandImmutableMap(parameters, values));
        return (Map)response.getValue();
    }

    private TouchAction createTap(WebElement element, int duration) {
        TouchAction tap = new TouchAction(this);
        return tap.press(element).waitAction(duration).release();
    }

    private TouchAction createTap(int x, int y, int duration) {
        TouchAction tap = new TouchAction(this);
        return tap.press(x, y).waitAction(duration).release();
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }
}

