/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.other;

import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.util.ReferenceUtil;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.util.ArrayList;
import java.util.List;

public class OasParameterUniquenessValidationRule
extends ValidationRule {
    public OasParameterUniquenessValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private int getParamCount(List<OasParameter> params, String paramName, String paramIn) {
        int count = 0;
        for (OasParameter param : params) {
            if (!this.hasValue(param) || !this.equals(param.name, paramName) || !this.equals(param.in, paramIn)) continue;
            ++count;
        }
        return count;
    }

    private void ensureUnique(List<OasParameter> params) {
        if (!this.hasValue(params)) {
            return;
        }
        ArrayList<OasParameter> resolvedParams = new ArrayList<OasParameter>(params.size());
        params.forEach(param -> {
            Node resolveNodeRef = ReferenceUtil.resolveNodeRef(param);
            if (resolveNodeRef instanceof OasParameter) {
                resolvedParams.add((OasParameter)resolveNodeRef);
            } else {
                resolvedParams.add((OasParameter)param);
            }
        });
        int idx = 0;
        for (OasParameter resolvedParam : resolvedParams) {
            int count;
            if (this.hasValue(resolvedParam) && this.hasValue(resolvedParam.in) && this.hasValue(resolvedParam.name) && !this.equals(resolvedParam.in, "body") && (count = this.getParamCount(resolvedParams, resolvedParam.name, resolvedParam.in)) > 1) {
                OasParameter param2 = params.get(idx);
                this.report(param2, "in", this.map("paramIn", resolvedParam.in, "paramName", resolvedParam.name));
            }
            ++idx;
        }
    }

    @Override
    public void visitPathItem(OasPathItem node) {
        this.ensureUnique(node.parameters);
    }

    @Override
    public void visitOperation(Operation node) {
        OasOperation op = (OasOperation)node;
        this.ensureUnique(op.parameters);
    }
}

