/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.util.ReferenceUtil;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OasInvalidPropertyValueRule
extends ValidationRule {
    public OasInvalidPropertyValueRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected boolean isValidMultipartType(String typeName) {
        return this.equals(typeName, "application/x-www-form-urlencoded") || typeName.indexOf("multipart") == 0;
    }

    protected List<OasParameter> mergeParameters(OasOperation node) {
        String key;
        OasParameter resolutionResult;
        HashMap<String, OasParameter> indexedParams = new HashMap<String, OasParameter>();
        OasPathItem parentNode = (OasPathItem)node.parent();
        if (this.hasValue(parentNode.parameters)) {
            for (OasParameter param : parentNode.parameters) {
                resolutionResult = (OasParameter)ReferenceUtil.resolveNodeRef(param);
                if (!this.hasValue(resolutionResult)) continue;
                key = resolutionResult.in + "-" + resolutionResult.name;
                indexedParams.put(key, resolutionResult);
            }
        }
        if (this.hasValue(node.parameters)) {
            for (OasParameter param : node.parameters) {
                resolutionResult = (OasParameter)ReferenceUtil.resolveNodeRef(param);
                if (!this.hasValue(resolutionResult)) continue;
                key = resolutionResult.in + "-" + resolutionResult.name;
                indexedParams.put(key, resolutionResult);
            }
        }
        ArrayList<OasParameter> mergedParameters = new ArrayList<OasParameter>();
        mergedParameters.addAll(indexedParams.values());
        return mergedParameters;
    }
}

