/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.name;

import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.name.OasInvalidPropertyNameRule;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OasIdenticalPathTemplateRule
extends OasInvalidPropertyNameRule {
    Map<String, List<ValidationRule.PathSegment>> indexedPathTemplates = new HashMap<String, List<ValidationRule.PathSegment>>();

    public OasIdenticalPathTemplateRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private List<String> findIdenticalPaths(String pathToCheck) {
        ArrayList<String> identicalPaths = new ArrayList<String>();
        List<ValidationRule.PathSegment> pathSegments = this.indexedPathTemplates.get(pathToCheck);
        for (String checkAgainst : this.indexedPathTemplates.keySet()) {
            if (this.equals(checkAgainst, pathToCheck)) continue;
            boolean segmentsIdentical = true;
            List<ValidationRule.PathSegment> pathSegmentsToCheckAgainst = this.indexedPathTemplates.get(checkAgainst);
            if (pathSegments.size() != pathSegmentsToCheckAgainst.size()) {
                segmentsIdentical = false;
            } else {
                int idx = 0;
                for (ValidationRule.PathSegment pathSegment : pathSegments) {
                    segmentsIdentical = segmentsIdentical && this.isSegmentIdentical(pathSegment, pathSegmentsToCheckAgainst.get(idx));
                    ++idx;
                }
            }
            if (!segmentsIdentical) continue;
            identicalPaths.add(checkAgainst);
        }
        return identicalPaths;
    }

    private boolean isSegmentIdentical(ValidationRule.PathSegment segment1, ValidationRule.PathSegment segment2) {
        if (this.equals(segment1.prefix, segment2.prefix)) {
            if (!this.hasValue(segment1.normalizedName) && !this.hasValue(segment2.normalizedName)) {
                return true;
            }
            if (!this.hasValue(segment1.normalizedName) && this.hasValue(segment2.normalizedName) || this.hasValue(segment1.normalizedName) && !this.hasValue(segment2.normalizedName)) {
                return false;
            }
            return this.equals(segment1.normalizedName, segment2.normalizedName);
        }
        return false;
    }

    @Override
    public void visitPaths(OasPaths node) {
        node.getPathItems().forEach(pathItem -> {
            String pathTemplate = pathItem.getPath();
            if (this.isPathWellFormed(pathTemplate)) {
                List<ValidationRule.PathSegment> pathSegments = this.getPathSegments(pathTemplate);
                this.indexedPathTemplates.put(pathTemplate, pathSegments);
            }
        });
    }

    @Override
    public void visitPathItem(OasPathItem node) {
        List<String> identicalPaths;
        String pathTemplate = node.getPath();
        if (this.isPathWellFormed(pathTemplate) && (identicalPaths = this.findIdenticalPaths(pathTemplate)).size() > 0) {
            this.reportPathError(node, this.map("path", node.getPath()));
        }
    }
}

