/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.factories;

import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.compat.RegexCompat;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import java.util.List;

public class OasSchemaFactory {
    public static IDefinition createSchemaDefinitionFromExample(OasDocument document, String name, Object example) {
        OasSchema schema = null;
        if (document.getDocumentType() == DocumentType.openapi2) {
            Oas20Document doc20 = (Oas20Document)document;
            if (NodeCompat.isNullOrUndefined(doc20.definitions)) {
                doc20.definitions = doc20.createDefinitions();
            }
            schema = doc20.definitions.createSchemaDefinition(name);
        } else if (document.getDocumentType() == DocumentType.openapi3) {
            Oas30Document doc30 = (Oas30Document)document;
            if (NodeCompat.isNullOrUndefined(doc30.components)) {
                doc30.components = doc30.createComponents();
            }
            schema = doc30.components.createSchemaDefinition(name);
        } else {
            throw new RuntimeException("Only OpenAPI 2 and 3 are currently supported.");
        }
        if (JsonCompat.isString(example)) {
            example = JsonCompat.parseJSON(JsonCompat.toString(example));
        }
        OasSchemaFactory.resolveAll(example, schema);
        schema.title = "Root Type for " + name;
        schema.description = "The root of the " + name + " type's schema.";
        return schema;
    }

    private static void resolveType(Object thing, OasSchema schema) {
        if (JsonCompat.isNumber(thing)) {
            boolean isInteger;
            Number value = JsonCompat.toNumber(thing);
            boolean bl = isInteger = ("" + value).indexOf(".") == -1;
            if (isInteger) {
                schema.type = "integer";
                if (value.intValue() >= -2147483647 && value.intValue() <= Integer.MAX_VALUE) {
                    schema.format = "int32";
                } else if (value.longValue() >= -9223372036854775807L && value.longValue() <= Long.MAX_VALUE) {
                    schema.format = "int64";
                }
            } else {
                schema.type = "number";
                schema.format = "double";
            }
        } else if (JsonCompat.isBoolean(thing)) {
            schema.type = "boolean";
        } else if (JsonCompat.isArray(thing)) {
            schema.type = "array";
        } else if (JsonCompat.isObject(thing)) {
            schema.type = "object";
        } else if (JsonCompat.isString(thing)) {
            String value = JsonCompat.toString(thing);
            schema.type = "string";
            if (RegexCompat.matches(value, "^(\\d{4})\\D?(0[1-9]|1[0-2])\\D?([12]\\d|0[1-9]|3[01])$")) {
                schema.format = "date";
            } else if (RegexCompat.matches(value, "^(\\d{4})\\D?(0[1-9]|1[0-2])\\D?([12]\\d|0[1-9]|3[01])(\\D?([01]\\d|2[0-3])\\D?([0-5]\\d)\\D?([0-5]\\d)?\\D?(\\d{3})?([zZ]|([\\+-])([01]\\d|2[0-3])\\D?([0-5]\\d)?)?)?$")) {
                schema.format = "date-time";
            }
        } else if (JsonCompat.isNull(thing)) {
            schema.type = "string";
        }
    }

    private static void resolveAll(Object object, OasSchema schema) {
        OasSchemaFactory.resolveType(object, schema);
        if (NodeCompat.equals(schema.type, "array")) {
            schema.items = schema.createItemsSchema();
            List<Object> list = JsonCompat.toList(object);
            if (list.size() > 0) {
                OasSchemaFactory.resolveAll(list.get(0), (OasSchema)schema.items);
            }
        } else if (NodeCompat.equals(schema.type, "object")) {
            schema.type = "object";
            List<String> keys = JsonCompat.keys(object);
            for (String propName : keys) {
                OasSchema pschema = (OasSchema)schema.createPropertySchema(propName);
                schema.addProperty(propName, pschema);
                Object propValue = JsonCompat.getProperty(object, propName);
                OasSchemaFactory.resolveAll(propValue, pschema);
            }
        }
    }
}

