/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.factories;

import io.apicurio.datamodels.asyncapi.v2.visitors.Aai20NodePathVisitor;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.visitors.NodePathVisitor;
import io.apicurio.datamodels.openapi.v2.visitors.Oas20NodePathVisitor;
import io.apicurio.datamodels.openapi.v3.visitors.Oas30NodePathVisitor;

public class NodePathVisitorFactory {
    public static NodePathVisitor createNodePathVisitor(Document doc) {
        switch (doc.getDocumentType()) {
            case asyncapi2: {
                return new Aai20NodePathVisitor();
            }
            case openapi2: {
                return new Oas20NodePathVisitor();
            }
            case openapi3: {
                return new Oas30NodePathVisitor();
            }
        }
        throw new RuntimeException("Failed to create a node path visitor for type: " + (Object)((Object)doc.getDocumentType()));
    }
}

