/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.ot;

import io.apicurio.datamodels.cmd.ot.OtCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import java.util.ArrayList;
import java.util.List;

public class OtEngine {
    private List<OtCommand> pendingCommands;
    private List<OtCommand> commands;
    private Document document;
    private List<Long> pendingUndos;

    public OtEngine(Document document) {
        this.document = document;
        this.pendingCommands = new ArrayList<OtCommand>();
        this.pendingUndos = new ArrayList<Long>();
        this.commands = new ArrayList<OtCommand>();
    }

    public Document getCurrentDocument() {
        return this.document;
    }

    public boolean hasPendingCommands() {
        return this.pendingCommands.size() > 0;
    }

    public boolean hasCommand(OtCommand command) {
        for (OtCommand cmd : this.commands) {
            if (cmd.contentVersion != command.contentVersion) continue;
            return true;
        }
        return false;
    }

    public void executeCommand(OtCommand command, boolean pending) {
        int insertionIdx;
        if (pending) {
            command.local = true;
            LoggerCompat.info("[OtEngine] Executing PENDING command with contentId: %o", command.contentVersion);
            command.execute(this.document);
            this.pendingCommands.add(command);
            this.pruneRevertedCommands();
            return;
        }
        if (this.hasCommand(command)) {
            LoggerCompat.info("[OtEngine] Detected duplicate OtCommand with content version: %o", command.contentVersion);
            return;
        }
        LoggerCompat.info("[OtEngine] Executing command with content version: %o", command.contentVersion);
        int pidx = this.pendingUndos.indexOf(command.contentVersion);
        if (pidx != -1) {
            this.pendingUndos.remove(pidx);
            command.reverted = true;
        }
        for (pidx = this.pendingCommands.size() - 1; pidx >= 0; --pidx) {
            if (this.pendingCommands.get((int)pidx).reverted) continue;
            this.pendingCommands.get((int)pidx).command.undo(this.document);
        }
        if (this.commands.size() > 0) {
            for (insertionIdx = this.commands.size() - 1; insertionIdx >= 0 && this.commands.get((int)insertionIdx).contentVersion > command.contentVersion; --insertionIdx) {
                if (this.commands.get((int)insertionIdx).reverted) continue;
                this.commands.get((int)insertionIdx).command.undo(this.document);
            }
        }
        this.commands.add(++insertionIdx, command);
        for (int idx = insertionIdx; idx < this.commands.size(); ++idx) {
            this.commands.get(idx).execute(this.document);
        }
        for (pidx = 0; pidx < this.pendingCommands.size(); ++pidx) {
            this.pendingCommands.get(pidx).execute(this.document);
        }
    }

    public void finalizeCommand(long pendingCommandId, long finalizedContentVersion) {
        int idx;
        int pidx;
        boolean isLatestCmd;
        LoggerCompat.info("[OtEngine] Finalizing command with contentId: %o  and new contentVersion: %o", pendingCommandId, finalizedContentVersion);
        boolean isFirstPendingCmd = this.pendingCommands.size() > 0 && this.pendingCommands.get((int)0).contentVersion == pendingCommandId;
        boolean bl = isLatestCmd = this.commands.size() == 0 || this.commands.get((int)(this.commands.size() - 1)).contentVersion < finalizedContentVersion;
        if (isFirstPendingCmd && isLatestCmd) {
            LoggerCompat.info("[OtEngine] Pending command is 'next up', performing simple shift from pending to finalized.", new Object[0]);
            OtCommand command = this.pendingCommands.remove(0);
            command.contentVersion = finalizedContentVersion;
            this.commands.add(command);
            return;
        }
        for (pidx = this.pendingCommands.size() - 1; pidx >= 0; --pidx) {
            if (this.pendingCommands.get((int)pidx).reverted) continue;
            this.pendingCommands.get((int)pidx).command.undo(this.document);
        }
        List<OtCommand> pending = this.pendingCommands;
        this.pendingCommands = new ArrayList<OtCommand>();
        boolean found = false;
        for (idx = 0; idx < pending.size(); ++idx) {
            if (pending.get((int)idx).contentVersion != pendingCommandId) continue;
            found = true;
            break;
        }
        if (found) {
            OtCommand command = pending.get(idx);
            pending.remove(idx);
            command.contentVersion = finalizedContentVersion;
            this.executeCommand(command, false);
        } else {
            LoggerCompat.info("[OtEngine] Attempted to finalize pending command %d but was not found.", pendingCommandId);
        }
        this.pendingCommands = pending;
        for (pidx = 0; pidx < this.pendingCommands.size(); ++pidx) {
            this.pendingCommands.get(pidx).execute(this.document);
        }
    }

    public OtCommand undoLastLocalCommand() {
        int idx;
        for (idx = this.pendingCommands.size() - 1; idx >= 0; --idx) {
            OtCommand cmd = this.pendingCommands.get(idx);
            if (cmd.reverted) continue;
            cmd.undo(this.document);
            return cmd;
        }
        OtCommand undoneCmd = null;
        if (undoneCmd == null) {
            for (idx = this.commands.size() - 1; idx >= 0; --idx) {
                OtCommand cmd = this.commands.get(idx);
                if (!cmd.local || cmd.reverted) continue;
                undoneCmd = cmd;
                break;
            }
        }
        if (undoneCmd != null) {
            this.undo(undoneCmd.contentVersion);
        }
        return undoneCmd;
    }

    public OtCommand redoLastLocalCommand() {
        if (this.pendingCommands.size() > 0) {
            OtCommand cmd = this.pendingCommands.get(this.pendingCommands.size() - 1);
            if (cmd.reverted) {
                cmd.redo(this.document);
                return cmd;
            }
            return null;
        }
        OtCommand redoneCmd = null;
        if (redoneCmd == null) {
            for (int idx = this.commands.size() - 1; idx >= 0; --idx) {
                OtCommand cmd = this.commands.get(idx);
                if (cmd.local && cmd.reverted) {
                    redoneCmd = cmd;
                }
                if (cmd.local && !cmd.reverted) break;
            }
        }
        if (redoneCmd != null) {
            this.redo(redoneCmd.contentVersion);
        }
        return redoneCmd;
    }

    public OtCommand undo(long contentVersion) {
        OtCommand cmd2;
        int idx;
        ArrayList<OtCommand> commandsToUndo = new ArrayList<OtCommand>();
        LoggerCompat.info("[OtEngine] Undo command with content version: %o", contentVersion);
        for (idx = this.pendingCommands.size() - 1; idx >= 0; --idx) {
            OtCommand cmd3 = this.pendingCommands.get(idx);
            commandsToUndo.add(cmd3);
        }
        boolean found = false;
        OtCommand foundCmd = null;
        for (idx = this.commands.size() - 1; idx >= 0; --idx) {
            cmd2 = this.commands.get(idx);
            commandsToUndo.add(cmd2);
            if (cmd2.contentVersion != contentVersion) continue;
            found = true;
            foundCmd = cmd2;
            break;
        }
        if (!found) {
            this.pendingUndos.add(contentVersion);
            return null;
        }
        commandsToUndo.forEach(cmd -> {
            if (!cmd.reverted) {
                cmd.command.undo(this.document);
            }
        });
        foundCmd.reverted = true;
        for (idx = commandsToUndo.size() - 1; idx >= 0; --idx) {
            cmd2 = (OtCommand)commandsToUndo.get(idx);
            cmd2.execute(this.document);
        }
        return foundCmd;
    }

    public OtCommand redo(long contentVersion) {
        OtCommand cmd2;
        int idx;
        ArrayList<OtCommand> commandsToUndo = new ArrayList<OtCommand>();
        LoggerCompat.info("[OtEngine] Redo command with content version: %o", contentVersion);
        for (idx = this.pendingCommands.size() - 1; idx >= 0; --idx) {
            OtCommand cmd3 = this.pendingCommands.get(idx);
            commandsToUndo.add(cmd3);
        }
        boolean found = false;
        OtCommand foundCmd = null;
        for (idx = this.commands.size() - 1; idx >= 0; --idx) {
            cmd2 = this.commands.get(idx);
            commandsToUndo.add(cmd2);
            if (cmd2.contentVersion != contentVersion) continue;
            found = true;
            foundCmd = cmd2;
            break;
        }
        if (!found) {
            idx = this.pendingUndos.indexOf(contentVersion);
            if (idx != -1) {
                this.pendingUndos.remove(idx);
            }
            return null;
        }
        commandsToUndo.forEach(cmd -> {
            if (!cmd.reverted) {
                cmd.command.undo(this.document);
            }
        });
        foundCmd.reverted = false;
        for (idx = commandsToUndo.size() - 1; idx >= 0; --idx) {
            cmd2 = (OtCommand)commandsToUndo.get(idx);
            cmd2.execute(this.document);
        }
        return foundCmd;
    }

    protected void pruneRevertedCommands() {
        ArrayList cmds = new ArrayList();
        this.commands.forEach(cmd -> {
            if (cmd.reverted) {
                cmds.add(cmd);
            }
        });
        cmds.forEach(cmd -> this.commands.remove(cmd));
        if (!cmds.isEmpty()) {
            LoggerCompat.info("[OtEngine] Pruned %d reverted commands", cmds.size());
        }
        ArrayList pcmds = new ArrayList();
        this.pendingCommands.forEach(cmd -> {
            if (cmd.reverted) {
                pcmds.add(cmd);
            }
        });
        pcmds.forEach(cmd -> this.pendingCommands.remove(cmd));
        if (!pcmds.isEmpty()) {
            LoggerCompat.info("[OtEngine] Pruned %d reverted pending commands", pcmds.size());
        }
    }
}

