/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiServer;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Server;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Server;
import java.util.LinkedHashMap;
import java.util.Map;

public class NewServerCommand_Aai20
extends AbstractCommand {
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _server;
    public String _serverName;
    public boolean _serverExisted;

    NewServerCommand_Aai20() {
    }

    NewServerCommand_Aai20(Aai20Document parent, Aai20Server server) {
        this._serverName = server.getName();
        this._server = Library.writeNode(server);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewServerCommand_Aai20] Executing.", new Object[0]);
        Aai20Document parent = (Aai20Document)document;
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        LinkedHashMap<String, AaiServer> servers = parent.servers;
        if (this.isNullOrUndefined(servers)) {
            servers = new LinkedHashMap<String, AaiServer>();
            NodeCompat.setProperty(parent, "servers", servers);
        }
        AaiServer server = parent.createServer(this._serverName);
        Library.readNode(this._server, server);
        if (this.serverAlreadyExists(parent)) {
            this._serverExisted = true;
            return;
        }
        servers.put(this._serverName, server);
        this._serverExisted = false;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewServerCommand_Aai20] Reverting.", new Object[0]);
        if (this._serverExisted) {
            return;
        }
        Aai20Document parent = (Aai20Document)document;
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(parent.servers)) {
            return;
        }
        Map servers = parent.servers;
        Server server = (Server)servers.get(this._serverName);
        if (this.isNullOrUndefined(server)) {
            return;
        }
        servers.remove(this._serverName);
        if (servers.size() == 0) {
            NodeCompat.setProperty(parent, "servers", null);
        }
    }

    private boolean serverAlreadyExists(Aai20Document parent) {
        return ModelUtils.isDefined(parent.servers.get(this._serverName));
    }
}

