/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IServerParent;
import io.apicurio.datamodels.core.models.common.Server;
import java.util.ArrayList;
import java.util.List;

public class NewServerCommand
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _server;
    public boolean _serverExisted;

    NewServerCommand() {
    }

    NewServerCommand(IServerParent parent, Server server) {
        this._parentPath = Library.createNodePath((Node)((Object)parent));
        this._server = Library.writeNode(server);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewServerCommand] Executing.", new Object[0]);
        IServerParent parent = (IServerParent)((Object)document);
        if (!this.isNullOrUndefined(this._parentPath)) {
            parent = (IServerParent)((Object)this._parentPath.resolve(document));
        }
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List<Server> servers = parent.getServers();
        if (this.isNullOrUndefined(servers)) {
            servers = new ArrayList<Server>();
            NodeCompat.setProperty(parent, "servers", servers);
        }
        Server server = parent.createServer();
        Library.readNode(this._server, server);
        if (this.serverAlreadyExists(parent, server)) {
            this._serverExisted = true;
            return;
        }
        servers.add(server);
        this._serverExisted = false;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewServerCommand] Reverting.", new Object[0]);
        if (this._serverExisted) {
            return;
        }
        IServerParent parent = (IServerParent)((Object)document);
        if (ModelUtils.isDefined(this._parentPath)) {
            parent = (IServerParent)((Object)this._parentPath.resolve(document));
        }
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(parent.getServers())) {
            return;
        }
        List<Server> servers = parent.getServers();
        String serverUrl = JsonCompat.getPropertyString(this._server, "url");
        Server server = parent.getServer(serverUrl);
        if (this.isNullOrUndefined(server)) {
            return;
        }
        servers.remove(servers.indexOf(server));
        if (servers.size() == 0) {
            NodeCompat.setProperty(parent, "servers", null);
        }
    }

    private boolean serverAlreadyExists(IServerParent parent, Server server) {
        return ModelUtils.isDefined(parent.getServer(server.url));
    }
}

