/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.AddResponseDefinitionCommand;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinition;

public class AddResponseDefinitionCommand_20
extends AddResponseDefinitionCommand {
    public boolean _nullDefinitions;

    AddResponseDefinitionCommand_20() {
    }

    AddResponseDefinitionCommand_20(String definitionName) {
        super(definitionName);
    }

    AddResponseDefinitionCommand_20(String definitionName, Object from) {
        super(definitionName, from);
    }

    @Override
    protected boolean defExists(OasDocument document) {
        Oas20Document doc20 = (Oas20Document)document;
        if (this.isNullOrUndefined(doc20.responses)) {
            return false;
        }
        return !this.isNullOrUndefined(doc20.responses.getResponse(this._newDefinitionName));
    }

    @Override
    protected void prepareDocumentForDef(OasDocument document) {
        Oas20Document doc20 = (Oas20Document)document;
        if (this.isNullOrUndefined(doc20.responses)) {
            doc20.responses = doc20.createResponseDefinitions();
            this._nullDefinitions = true;
        }
    }

    @Override
    protected OasResponse createResponseDefinition(OasDocument document) {
        Oas20Document doc20 = (Oas20Document)document;
        Oas20ResponseDefinition definition = doc20.responses.createResponse(this._newDefinitionName);
        Library.readNode(this._newDefinitionObj, definition);
        return definition;
    }

    @Override
    protected void addDefinition(OasDocument document, OasResponse definition) {
        Oas20Document doc20 = (Oas20Document)document;
        Oas20ResponseDefinition def20 = (Oas20ResponseDefinition)definition;
        doc20.responses.addResponse(this._newDefinitionName, def20);
    }

    @Override
    protected void removeDefinition(OasDocument document) {
        Oas20Document doc20 = (Oas20Document)document;
        if (this._nullDefinitions) {
            doc20.responses = null;
        } else {
            doc20.responses.removeResponse(this._newDefinitionName);
        }
    }
}

