/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.avro.record;

import com.typesafe.config.Config;
import io.amient.affinity.avro.AvroSchemaRegistry;
import io.amient.affinity.avro.record.AvroRecord;
import io.amient.affinity.avro.record.AvroRecord$;
import io.amient.affinity.avro.record.AvroSerde$;
import io.amient.affinity.core.config.Cfg;
import io.amient.affinity.core.config.CfgStruct;
import io.amient.affinity.core.serde.AbstractSerde;
import io.amient.affinity.core.util.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.ByteBufferInputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=r!\u0002\u0014(\u0011\u0003\u0011d!\u0002\u001b(\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%Ia\u0010\u0005\u0007\u0007\u0006\u0001\u000b\u0011\u0002!\b\u000b\u0011\u000b\u0001\u0012A#\u0007\u000b\u001d\u000b\u0001\u0012\u0001%\t\rq2A\u0011AAm\u0011\u001d\tYN\u0002C!\u0003;D\u0011\"a=\u0007\u0003\u0003%I!!>\u0007\t\u001d\u000b\u0001A\u0013\u0005\u0006y)!\ta\u0015\u0005\b)*\u0011\r\u0011\"\u0001V\u0011\u001d\t9N\u0003Q\u0001\nY;q!a>\u0002\u0011\u0003\tIP\u0002\u0004X\u0003!\u0005\u00111 \u0005\u0007y=!\t!!@\t\u000f\u0005mw\u0002\"\u0011\u0002\u0000\"I\u00111_\b\u0002\u0002\u0013%\u0011Q\u001f\u0004\u0005/\u0006\u0001\u0001\fC\u0003='\u0011\u0005!\fC\u0004\\'\t\u0007I\u0011\u0001/\t\u000f\u0005}6\u0003)A\u0005;\"9\u0011\u0011Y\n\u0005R\u0005\r\u0007b\u0002B\u0002\u0003\u0011\u0005!Q\u0001\u0005\b\u0005\u0007\tA\u0011\u0001B\u0005\u0011\u001d\u0011y!\u0001C\u0001\u0005#1q\u0001N\u0014\u0011\u0002\u0007\u0005A\u000fC\u0004\u0002\fm!\t!!\u0004\t\u000f\u0005U1\u0004\"\u0011\u0002\u000e!9\u0011qC\u000e\u0005B\u0005e\u0001bBA\u00137\u0011\u0005\u0013q\u0005\u0005\b\u0003[YB\u0011AA\u0018\u0011\u001d\tic\u0007C\u0001\u0003+Bq!!\u001b\u001c\t\u0003\tY\u0007C\u0004\u0002jm!\t!! \t\u000f\u0005%4\u0004\"\u0001\u0002\u0002\"9\u0011\u0011S\u000e\u0005B\u0005M\u0015!C!we>\u001cVM\u001d3f\u0015\tA\u0013&\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003U-\nA!\u0019<s_*\u0011A&L\u0001\tC\u001a4\u0017N\\5us*\u0011afL\u0001\u0007C6LWM\u001c;\u000b\u0003A\n!![8\u0004\u0001A\u00111'A\u0007\u0002O\tI\u0011I\u001e:p'\u0016\u0014H-Z\n\u0003\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00013\u0003\u0015i\u0015iR%D+\u0005\u0001\u0005CA\u001cB\u0013\t\u0011\u0005H\u0001\u0003CsR,\u0017AB'B\u000f&\u001b\u0005%A\u0004BEN\u001cuN\u001c4\u0011\u0005\u00193Q\"A\u0001\u0003\u000f\u0005\u00137oQ8oMN\u0011a!\u0013\t\u0003\r*\u0019\"AC&\u0011\u00071\u000b\u0016*D\u0001N\u0015\tqu*\u0001\u0004d_:4\u0017n\u001a\u0006\u0003!.\nAaY8sK&\u0011!+\u0014\u0002\n\u0007\u001a<7\u000b\u001e:vGR$\u0012!S\u0001\u0005\u0003Z\u0014x.F\u0001W!\t15C\u0001\u0005BmJ|7i\u001c8g'\t\u0019\u0012\fE\u0002M#Z#\u0012AV\u0001\u0006\u00072\f7o]\u000b\u0002;B\u0019AJ\u00181\n\u0005}k%aA\"gOB\u0012\u0011m\u001b\t\u0004E\u001eLW\"A2\u000b\u0005\u0011,\u0017\u0001\u00027b]\u001eT\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iG\n)1\t\\1tgB\u0011!n\u001b\u0007\u0001\t%a\u0007!!A\u0001\u0002\u000b\u0005qN\u0001\u0002@a%\u0011a.\u0014\u0002\u0007\u0007\u001a<7\t\\:\u0012\u0005A\u001c\bCA\u001cr\u0013\t\u0011\bHA\u0004O_RD\u0017N\\4\u0011\u0005MZ2#B\u000evq\u0006\r\u0001C\u00012w\u0013\t98M\u0001\u0004PE*,7\r\u001e\t\u0004srtX\"\u0001>\u000b\u0005m|\u0015!B:fe\u0012,\u0017BA?{\u00055\t%m\u001d;sC\u000e$8+\u001a:eKB\u0011qg`\u0005\u0004\u0003\u0003A$aA!osB!\u0011QAA\u0004\u001b\u0005I\u0013bAA\u0005S\t\u0011\u0012I\u001e:p'\u000eDW-\\1SK\u001eL7\u000f\u001e:z\u0003\u0019!\u0013N\\5uIQ\u0011\u0011q\u0002\t\u0004o\u0005E\u0011bAA\nq\t!QK\\5u\u0003\u0015\u0019Gn\\:f\u0003%1'o\\7CsR,7\u000fF\u0002\u007f\u00037Aq!!\b\u001f\u0001\u0004\ty\"A\u0003csR,7\u000f\u0005\u00038\u0003C\u0001\u0015bAA\u0012q\t)\u0011I\u001d:bs\u00069Ao\u001c\"zi\u0016\u001cH\u0003BA\u0010\u0003SAa!a\u000b \u0001\u0004q\u0018aA8cU\u0006)qO]5uKR1\u0011qDA\u0019\u0003\u0017Bq!a\r!\u0001\u0004\t)$A\u0001y!\u0011\t9$a\u0012\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tqaZ3oKJL7MC\u0002+\u0003\u007fQA!!\u0011\u0002D\u00051\u0011\r]1dQ\u0016T!!!\u0012\u0002\u0007=\u0014x-\u0003\u0003\u0002J\u0005e\"!D%oI\u0016DX\r\u001a*fG>\u0014H\rC\u0004\u0002N\u0001\u0002\r!a\u0014\u0002\u0011M\u001c\u0007.Z7b\u0013\u0012\u00042aNA)\u0013\r\t\u0019\u0006\u000f\u0002\u0004\u0013:$H\u0003CA\u0010\u0003/\nY&a\u001a\t\r\u0005e\u0013\u00051\u0001\u007f\u0003\u00151\u0018\r\\;f\u0011\u001d\ti&\ta\u0001\u0003?\naa]2iK6\f\u0007\u0003BA1\u0003Gj!!!\u0010\n\t\u0005\u0015\u0014Q\b\u0002\u0007'\u000eDW-\\1\t\u000f\u00055\u0013\u00051\u0001\u0002P\u0005!!/Z1e)\rq\u0018Q\u000e\u0005\b\u0003_\u0012\u0003\u0019AA9\u0003\r\u0011WO\u001a\t\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011qO3\u0002\u00079Lw.\u0003\u0003\u0002|\u0005U$A\u0003\"zi\u0016\u0014UO\u001a4feR\u0019a0a \t\u000f\u0005u1\u00051\u0001\u0002 Q\u0019a0a!\t\u000f\u0005\u0015E\u00051\u0001\u0002\b\u00069!-\u001f;fg&s\u0007\u0003BAE\u0003\u001bk!!a#\u000b\u0005A*\u0017\u0002BAH\u0003\u0017\u00131\"\u00138qkR\u001cFO]3b[\u00061\u0001O]3gSb$b!a\b\u0002\u0016\u0006]\u0006bBALK\u0001\u0007\u0011\u0011T\u0001\u0004G2\u001c\b\u0007BAN\u0003c\u0003b!!(\u0002,\u0006=f\u0002BAP\u0003O\u00032!!)9\u001b\t\t\u0019KC\u0002\u0002&F\na\u0001\u0010:p_Rt\u0014bAAUq\u00051\u0001K]3eK\u001aL1\u0001[AW\u0015\r\tI\u000b\u000f\t\u0004U\u0006EF\u0001DAZ\u0003+\u000b\t\u0011!A\u0003\u0002\u0005U&aA0%gE\u0011\u0001O \u0005\b\u0003#+\u0003\u0019AA]!\u00119\u00141X;\n\u0007\u0005u\u0006H\u0001\u0006=e\u0016\u0004X-\u0019;fIz\naa\u00117bgN\u0004\u0013aD:qK\u000eL\u0017\r\\5{CRLwN\\:\u0015\u0005\u0005\u0015\u0007CBAd\u0003\u001b\f\t.\u0004\u0002\u0002J*\u0019\u00111Z3\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u001f\fIMA\u0002TKR\u0004B!!(\u0002T&!\u0011Q[AW\u0005\u0019\u0019FO]5oO\u0006)\u0011I\u001e:pAQ\tQ)A\u0003baBd\u0017\u0010F\u0002J\u0003?DaA\u0014\u0005A\u0002\u0005\u0005\b\u0003BAr\u0003_l!!!:\u000b\u00079\u000b9O\u0003\u0003\u0002j\u0006-\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u00055\u0018aA2p[&!\u0011\u0011_As\u0005\u0019\u0019uN\u001c4jO\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005)\u0018\u0001C!we>\u001cuN\u001c4\u0011\u0005\u0019{1CA\bW)\t\tI\u0010F\u0002W\u0005\u0003AaAT\tA\u0002\u0005\u0005\u0018AB2sK\u0006$X\rF\u0002t\u0005\u000fAaA\u0014\rA\u0002\u0005\u0005HcA:\u0003\f!1!QB\rA\u0002Y\u000bAaY8oM\u0006\u0011\"-\u001b8bef\u0004&/\u001a4jq2+gn\u001a;i)\u0011\u0011\u0019B!\u0007\u0011\u000b]\u0012)\"a\u0014\n\u0007\t]\u0001H\u0001\u0004PaRLwN\u001c\u0005\b\u00057Q\u0002\u0019\u0001B\u000f\u0003-\u0011XmY8sI\u000ec\u0017m]:1\t\t}!1\u0005\t\u0007\u0003;\u000bYK!\t\u0011\u0007)\u0014\u0019\u0003\u0002\u0007\u0003&\te\u0011\u0011!A\u0001\u0006\u0003\u00119CA\u0002`II\n2\u0001\u001dB\u0015!\r\u0019$1F\u0005\u0004\u0005[9#AC!we>\u0014VmY8sI\u0002")
public interface AvroSerde
extends AbstractSerde<Object>,
AvroSchemaRegistry {
    public static Option<Object> binaryPrefixLength(Class<? extends AvroRecord> clazz) {
        return AvroSerde$.MODULE$.binaryPrefixLength(clazz);
    }

    public static AvroSerde create(AvroConf avroConf) {
        return AvroSerde$.MODULE$.create(avroConf);
    }

    public static AvroSerde create(Config config) {
        return AvroSerde$.MODULE$.create(config);
    }

    public static /* synthetic */ void close$(AvroSerde $this) {
        $this.close();
    }

    @Override
    default public void close() {
    }

    public static /* synthetic */ Object fromBytes$(AvroSerde $this, byte[] bytes) {
        return $this.fromBytes(bytes);
    }

    default public Object fromBytes(byte[] bytes) {
        return this.read(bytes);
    }

    public static /* synthetic */ byte[] toBytes$(AvroSerde $this, Object obj) {
        return $this.toBytes(obj);
    }

    default public byte[] toBytes(Object obj) {
        byte[] byArray;
        if (obj == null) {
            byArray = null;
        } else {
            Tuple2 tuple2 = this.from(obj);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int schemaId = tuple2._1$mcI$sp();
            Schema schema = (Schema)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)schemaId), (Object)schema);
            Tuple2 tuple23 = tuple22;
            int schemaId2 = tuple23._1$mcI$sp();
            Schema schema2 = (Schema)tuple23._2();
            byArray = this.write(obj, schema2, schemaId2);
        }
        return byArray;
    }

    public static /* synthetic */ byte[] write$(AvroSerde $this, IndexedRecord x, int schemaId) {
        return $this.write(x, schemaId);
    }

    default public byte[] write(IndexedRecord x, int schemaId) {
        return this.write(x, x.getSchema(), schemaId);
    }

    public static /* synthetic */ byte[] write$(AvroSerde $this, Object value, Schema schema, int schemaId) {
        return $this.write(value, schema, schemaId);
    }

    default public byte[] write(Object value, Schema schema, int schemaId) {
        byte[] byArray;
        Predef$.MODULE$.require(schemaId >= 0, (Function0 & Serializable & scala.Serializable)() -> "avro schema id cannot be negative");
        Object object = value;
        if (object == null) {
            byArray = null;
        } else if (object instanceof Object) {
            byte[] byArray2;
            try (ByteArrayOutputStream valueOut = new ByteArrayOutputStream();){
                valueOut.write(AvroSerde$.MODULE$.io$amient$affinity$avro$record$AvroSerde$$MAGIC());
                ByteUtils.writeIntValue((int)schemaId, (OutputStream)valueOut);
                AvroRecord$.MODULE$.write(value, schema, valueOut);
                byArray2 = valueOut.toByteArray();
            }
            byArray = byArray2;
        } else {
            throw new MatchError(object);
        }
        return byArray;
    }

    public static /* synthetic */ Object read$(AvroSerde $this, ByteBuffer buf) {
        return $this.read(buf);
    }

    default public Object read(ByteBuffer buf) {
        return buf == null ? null : this.read((InputStream)new ByteBufferInputStream((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)buf, (List)Nil$.MODULE$)).asJava()));
    }

    public static /* synthetic */ Object read$(AvroSerde $this, byte[] bytes) {
        return $this.read(bytes);
    }

    default public Object read(byte[] bytes) {
        Object object;
        if (bytes == null) {
            object = null;
        } else {
            Schema readerSchema;
            Schema schema;
            Predef$.MODULE$.require(bytes.length >= 5, (Function0 & Serializable & scala.Serializable)() -> "binary representation of avro message must consist of at least 5 bytes");
            Predef$.MODULE$.require(bytes[0] == AvroSerde$.MODULE$.io$amient$affinity$avro$record$AvroSerde$$MAGIC(), (Function0 & Serializable & scala.Serializable)() -> "binary representation of avro message doesn't start with the correct magic byte");
            int schemaId = ByteUtils.asIntValue((byte[])bytes, (int)1);
            Predef$.MODULE$.require(schemaId >= 0, (Function0 & Serializable & scala.Serializable)() -> "avro schema id cannot be negative");
            try {
                schema = this.getSchema(schemaId);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new RuntimeException(new StringBuilder(26).append("Could not get schema id : ").append(schemaId).toString(), e);
                }
                throw throwable;
            }
            Schema writerSchema = schema;
            Tuple2 tuple2 = this.getRuntimeSchema(writerSchema);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Schema schema2 = readerSchema = (Schema)tuple2._2();
            Schema readerSchema2 = schema2;
            object = AvroRecord$.MODULE$.read(bytes, writerSchema, readerSchema2, 5);
        }
        return object;
    }

    public static /* synthetic */ Object read$(AvroSerde $this, InputStream bytesIn) {
        return $this.read(bytesIn);
    }

    default public Object read(InputStream bytesIn) {
        Schema readerSchema;
        Predef$.MODULE$.require(bytesIn.read() == AvroSerde$.MODULE$.io$amient$affinity$avro$record$AvroSerde$$MAGIC(), (Function0 & Serializable & scala.Serializable)() -> "avro binary doesn't start with magic byte");
        int schemaId = ByteUtils.readIntValue((InputStream)bytesIn);
        Predef$.MODULE$.require(schemaId >= 0, (Function0 & Serializable & scala.Serializable)() -> "avro schema id cannot be negative");
        Schema writerSchema = this.getSchema(schemaId);
        Tuple2 tuple2 = this.getRuntimeSchema(writerSchema);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Schema schema = readerSchema = (Schema)tuple2._2();
        Schema readerSchema2 = schema;
        return AvroRecord$.MODULE$.read(bytesIn, writerSchema, readerSchema2);
    }

    public static /* synthetic */ byte[] prefix$(AvroSerde $this, Class cls, Seq prefix) {
        return $this.prefix(cls, (Seq<Object>)prefix);
    }

    default public byte[] prefix(Class<?> cls, Seq<Object> prefix) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Schema schema = AvroRecord$.MODULE$.inferSchema(cls);
        int schemaId = this.register(cls);
        output.write(0);
        ByteUtils.writeIntValue((int)schemaId, (OutputStream)output);
        ((IterableLike)prefix.zip((GenIterable)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).take(prefix.length())).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AvroSerde.$anonfun$prefix$1(x$5)), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AvroSerde.$anonfun$prefix$2(output, x0$1);
            return BoxedUnit.UNIT;
        });
        return output.toByteArray();
    }

    public static /* synthetic */ byte[] prefix$(AvroSerde $this, Class cls, Object[] prefix) {
        return $this.prefix(cls, prefix);
    }

    default public byte[] prefix(Class<?> cls, Object[] prefix) {
        return this.prefix(cls, (Seq<Object>)Predef$.MODULE$.wrapRefArray(prefix));
    }

    public static /* synthetic */ int $anonfun$prefix$1(Schema.Field x$5) {
        return x$5.schema().getFixedSize();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static /* synthetic */ void $anonfun$prefix$2(ByteArrayOutputStream output$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int n;
            byte[] byArray;
            Object value = tuple2._1();
            int fixedLen = tuple2._2$mcI$sp();
            if (value instanceof byte[] && (byArray = (byte[])value).length == (n = fixedLen)) {
                output$1.write(byArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object value = tuple2._1();
            int fixedLen = tuple2._2$mcI$sp();
            if (value instanceof String) {
                String string = (String)value;
                int n = fixedLen;
                output$1.write(AvroRecord$.MODULE$.stringToFixed(string, n));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Object value = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (value instanceof Integer) {
                Integer n2 = (Integer)value;
                if (4 == n) {
                    ByteUtils.writeIntValue((int)Predef$.MODULE$.Integer2int(n2), (OutputStream)output$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Object value = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (value instanceof Long) {
                Long l = (Long)value;
                if (8 == n) {
                    ByteUtils.writeLongValue((long)Predef$.MODULE$.Long2long(l), (OutputStream)output$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object value = tuple2._1();
        int n = tuple2._2$mcI$sp();
        if (!(value instanceof UUID)) throw new MatchError((Object)tuple2);
        UUID uUID = (UUID)value;
        if (16 != n) throw new MatchError((Object)tuple2);
        output$1.write(ByteUtils.uuid((UUID)uUID));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void $init$(AvroSerde $this) {
    }

    public static class AbsConf
    extends CfgStruct<AbsConf> {
        private final AvroConf Avro = (AvroConf)this.struct("affinity.avro", new AvroConf(), true);

        public AvroConf Avro() {
            return this.Avro;
        }

        public AbsConf() {
            super(new Cfg.Options[]{Cfg.Options.IGNORE_UNKNOWN});
        }
    }

    public static class AvroConf
    extends CfgStruct<AvroConf> {
        private final Cfg<Class<? extends AvroSerde>> Class = this.cls("schema.registry.class", AvroSerde.class, true).doc("one of ConfluentSchemaRegistry, ZookeeperSchemaRegistry, LocalSchemaRegistry or MemorySchemaRegistry from the io.amient.affinity.avro package");

        public Cfg<Class<? extends AvroSerde>> Class() {
            return this.Class;
        }

        public java.util.Set<String> specializations() {
            return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schema.registry"}))).asJava();
        }
    }
}

