/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.avro;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0007\u000f\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006O\u0001!\t\u0001\u000b\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0011\u0019Q\u0004\u0001)A\u0005]!)1\b\u0001C\u0001y!)\u0011\u000b\u0001C\u0001%\")\u0011\f\u0001C\u00015\")\u0011\f\u0001C\u0001Q\")1\u000e\u0001C\u0001Y\")\u0001\u000f\u0001C\u0005c\")A\u000f\u0001C\u0005k\")\u0011\u0010\u0001C\u0005u\ni2i\u001c8gYV,g\u000e^*dQ\u0016l\u0017MU3hSN$(/_\"mS\u0016tGO\u0003\u0002\u0010!\u0005!\u0011M\u001e:p\u0015\t\t\"#\u0001\u0005bM\u001aLg.\u001b;z\u0015\t\u0019B#\u0001\u0004b[&,g\u000e\u001e\u0006\u0002+\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\bE\u0006\u001cX-\u0016:m!\t\u0001S%D\u0001\"\u0015\t\u00113%A\u0002oKRT\u0011\u0001J\u0001\u0005U\u00064\u0018-\u0003\u0002'C\t\u0019QK\u0015'\u0002\rqJg.\u001b;?)\tI3\u0006\u0005\u0002+\u00015\ta\u0002C\u0003\u001f\u0005\u0001\u0007q$\u0001\u0004nCB\u0004XM]\u000b\u0002]A\u0011q\u0006O\u0007\u0002a)\u0011\u0011GM\u0001\u0004[\u0006\u0004(BA\u001a5\u0003\u001dQ\u0017mY6t_:T!!\u000e\u001c\u0002\u0011\r|G-\u001a5bkNT\u0011aN\u0001\u0004_J<\u0017BA\u001d1\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003\u001di\u0017\r\u001d9fe\u0002\n1bZ3u'V\u0014'.Z2ugV\tQ\bE\u0002?\r&s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\t3\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\t)%$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%\u0001C%uKJ\fGo\u001c:\u000b\u0005\u0015S\u0002C\u0001&O\u001d\tYE\n\u0005\u0002A5%\u0011QJG\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002N5\u0005Yq-\u001a;WKJ\u001c\u0018n\u001c8t)\t\u0019v\u000bE\u0002?\rR\u0003\"!G+\n\u0005YS\"aA%oi\")\u0001L\u0002a\u0001\u0013\u000691/\u001e2kK\u000e$\u0018!C4fiN\u001b\u0007.Z7b)\rYVM\u001a\t\u00053q#f,\u0003\u0002^5\t1A+\u001e9mKJ\u0002\"aX2\u000e\u0003\u0001T!aD1\u000b\u0005\t4\u0014AB1qC\u000eDW-\u0003\u0002eA\n11k\u00195f[\u0006DQ\u0001W\u0004A\u0002%CQaZ\u0004A\u0002Q\u000bqA^3sg&|g\u000e\u0006\u0002_S\")!\u000e\u0003a\u0001)\u0006\u0011\u0011\u000eZ\u0001\u000fe\u0016<\u0017n\u001d;feN\u001b\u0007.Z7b)\r!VN\u001c\u0005\u00061&\u0001\r!\u0013\u0005\u0006_&\u0001\rAX\u0001\u0007g\u000eDW-\\1\u0002\u0007\u001d,G\u000f\u0006\u0002Je\")1O\u0003a\u0001\u0013\u0006!\u0001/\u0019;i\u0003\u0011\u0001xn\u001d;\u0015\u0007%3x\u000fC\u0003t\u0017\u0001\u0007\u0011\nC\u0003y\u0017\u0001\u0007\u0011*\u0001\u0004f]RLG/_\u0001\u0005QR$\b\u000fF\u0002|\u0003\u001f!\"!\u0013?\t\u000bud\u0001\u0019\u0001@\u0002\t%t\u0017\u000e\u001e\t\u00073}\f\u0019!!\u0003\n\u0007\u0005\u0005!DA\u0005Gk:\u001cG/[8ocA\u0019\u0001%!\u0002\n\u0007\u0005\u001d\u0011EA\tIiR\u0004XK\u0015'D_:tWm\u0019;j_:\u00042!GA\u0006\u0013\r\tiA\u0007\u0002\u0005+:LG\u000fC\u0003t\u0019\u0001\u0007\u0011\n")
public class ConfluentSchemaRegistryClient {
    private final URL baseUrl;
    private final ObjectMapper mapper;

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public Iterator<String> getSubjects() {
        Iterator iterator;
        JsonNode j = (JsonNode)this.mapper().readValue(this.get("/subjects"), JsonNode.class);
        if (!j.has("error_code")) {
            iterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(j.getElements()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getTextValue());
        } else if (j.get("error_code").getIntValue() == 40401) {
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            throw new RuntimeException(j.get("message").getTextValue());
        }
        return iterator;
    }

    public Iterator<Object> getVersions(String subject) {
        Iterator iterator;
        JsonNode j = (JsonNode)this.mapper().readValue(this.get(new StringBuilder(19).append("/subjects/").append(subject).append("/versions").toString()), JsonNode.class);
        if (!j.has("error_code")) {
            iterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(j.getElements()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getIntValue()));
        } else if (j.get("error_code").getIntValue() == 40401) {
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            throw new RuntimeException(j.get("message").getTextValue());
        }
        return iterator;
    }

    public Tuple2<Object, Schema> getSchema(String subject, int version) {
        JsonNode j = (JsonNode)this.mapper().readValue(this.get(new StringBuilder(20).append("/subjects/").append(subject).append("/versions/").append(version).toString()), JsonNode.class);
        if (j.has("error_code")) {
            throw new RuntimeException(j.get("message").getTextValue());
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j.get("id").getIntValue()), (Object)new Schema.Parser().parse(j.get("schema").getTextValue()));
    }

    public Schema getSchema(int id) {
        JsonNode j = (JsonNode)this.mapper().readValue(this.get(new StringBuilder(13).append("/schemas/ids/").append(id).toString()), JsonNode.class);
        if (j.has("error_code")) {
            throw new RuntimeException(j.get("message").getTextValue());
        }
        return new Schema.Parser().parse(j.get("schema").getTextValue());
    }

    public int registerSchema(String subject, Schema schema) {
        ObjectNode entity = this.mapper().createObjectNode();
        entity.put("schema", schema.toString());
        JsonNode j = (JsonNode)this.mapper().readValue(this.post(new StringBuilder(19).append("/subjects/").append(subject).append("/versions").toString(), entity.toString()), JsonNode.class);
        if (j.has("error_code")) {
            throw new RuntimeException(new StringBuilder(53).append("could not register schema subject: ").append(schema.getFullName()).append(" due to ").append(j.get("message").getTextValue()).append(", schema: ").append(schema).toString());
        }
        if (!j.has("id")) {
            throw new IllegalArgumentException();
        }
        return j.get("id").getIntValue();
    }

    private String get(String path) {
        return this.http(path, (Function1<HttpURLConnection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)connection -> {
            ConfluentSchemaRegistryClient.$anonfun$get$1(this, path, connection);
            return BoxedUnit.UNIT;
        });
    }

    private String post(String path, String entity) {
        return this.http(path, (Function1<HttpURLConnection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)connection -> {
            ConfluentSchemaRegistryClient.$anonfun$post$1(this, path, entity, connection);
            return BoxedUnit.UNIT;
        });
    }

    private String http(String path, Function1<HttpURLConnection, BoxedUnit> init) {
        String content;
        block2: {
            URL url = new URL(new StringBuilder(0).append(this.baseUrl.toString()).append(path).toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(15000);
            if (url.getUserInfo() != null) {
                String string = url.getUserInfo();
                String string2 = "";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    connection.setRequestProperty("Authorization", new StringBuilder(6).append("Basic ").append(new String(Base64.getEncoder().encode(url.getUserInfo().getBytes()))).toString());
                }
            }
            init.apply((Object)connection);
            int status = connection.getResponseCode();
            InputStream inputStream = status == 200 ? connection.getInputStream() : connection.getErrorStream();
            content = Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
            if (inputStream == null) break block2;
            inputStream.close();
        }
        return content;
    }

    public static final /* synthetic */ void $anonfun$get$1(ConfluentSchemaRegistryClient $this, String path$1, HttpURLConnection connection) {
        try {
            connection.setRequestMethod("GET");
        }
        catch (ConnectException connectException) {
            throw new ConnectException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)$this.baseUrl), path$1));
        }
    }

    public static final /* synthetic */ void $anonfun$post$1(ConfluentSchemaRegistryClient $this, String path$2, String entity$1, HttpURLConnection connection) {
        DataOutputStream dataOutputStream;
        connection.addRequestProperty("Content-Type", "application/json");
        connection.addRequestProperty("Accept", "application/vnd.schemaregistry.v1+json, application/vnd.schemaregistry+json, application/json");
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        try {
            dataOutputStream = new DataOutputStream(connection.getOutputStream());
        }
        catch (ConnectException connectException) {
            throw new ConnectException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)$this.baseUrl), path$2));
        }
        DataOutputStream output = dataOutputStream;
        output.write(entity$1.getBytes("UTF-8"));
    }

    public ConfluentSchemaRegistryClient(URL baseUrl) {
        this.baseUrl = baseUrl;
        this.mapper = new ObjectMapper();
    }
}

