/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import com.typesafe.config.Config;
import io.amient.affinity.core.storage.Log;
import io.amient.affinity.core.storage.LogEntry;
import io.amient.affinity.core.storage.LogStorageConf;
import io.amient.affinity.core.storage.Record;
import io.amient.affinity.core.util.TimeRange;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;

public interface LogStorage<POS extends Comparable<POS>>
extends Closeable {
    public static final LogStorageConf StorageConf = new LogStorageConf(){

        @Override
        public LogStorageConf apply(Config config) {
            return (LogStorageConf)new LogStorageConf().apply(config);
        }
    };

    public static LogStorage newInstance(Config config) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return LogStorage.newInstance((LogStorageConf)StorageConf.apply(config));
    }

    public static LogStorage newInstanceEnsureExists(LogStorageConf conf) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        LogStorage instance = LogStorage.newInstance(conf);
        instance.ensureExists();
        return instance;
    }

    public static LogStorage newInstance(LogStorageConf conf) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<? extends LogStorage> cls = conf.Class.apply();
        return cls.getConstructor(LogStorageConf.class).newInstance(conf);
    }

    default public Log<POS> open(Path checkpointFile) {
        return new Log(this, checkpointFile);
    }

    public String getStats();

    public String getTopic();

    public int getNumPartitions();

    public void resume(TimeRange var1);

    public void reset(int var1, TimeRange var2);

    public POS reset(int var1, POS var2);

    public String keySubject();

    public String valueSubject();

    public void ensureExists();

    public void ensureCorrectConfiguration(long var1, int var3, boolean var4);

    public Iterator<LogEntry<POS>> fetch(boolean var1) throws InterruptedException;

    public void cancel();

    public Future<Long> commit();

    public Future<POS> append(Record<byte[], byte[]> var1);

    public Future<POS> delete(byte[] var1);

    public void flush();

    default public Iterator<LogEntry<POS>> boundedIterator() {
        return this.iterator(false);
    }

    default public Iterator<LogEntry<POS>> unboundedIterator() {
        return this.iterator(true);
    }

    default public Iterator<LogEntry<POS>> iterator(final boolean unbounded) {
        return new Iterator<LogEntry<POS>>(){
            private LogEntry<POS> record = null;
            private Iterator<LogEntry<POS>> i = null;

            @Override
            public boolean hasNext() {
                if (this.i == null) {
                    this.seek();
                }
                return this.record != null;
            }

            @Override
            public LogEntry<POS> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                LogEntry result = this.record;
                this.seek();
                return result;
            }

            void seek() {
                this.record = null;
                while (this.i == null || !this.i.hasNext()) {
                    try {
                        this.i = LogStorage.this.fetch(unbounded);
                        if (this.i != null) continue;
                        return;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.i.hasNext()) {
                    this.record = this.i.next();
                }
            }
        };
    }
}

