/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import io.airlift.stats.GcMonitor;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public class TestingGcMonitor
implements GcMonitor {
    @GuardedBy(value="this")
    private long majorGcCount;
    @GuardedBy(value="this")
    private long majorGcTimeNanos;

    public synchronized void recordMajorGc(Duration duration) {
        ++this.majorGcCount;
        this.majorGcTimeNanos += duration.roundTo(TimeUnit.NANOSECONDS);
    }

    @Override
    public synchronized long getMajorGcCount() {
        return this.majorGcCount;
    }

    @Override
    public synchronized Duration getMajorGcTime() {
        return new Duration((double)this.majorGcTimeNanos, TimeUnit.NANOSECONDS);
    }
}

