/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.transaction.TransactionAware;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.pool.ConnectionFactory;
import io.agroal.pool.ConnectionHandler;
import io.agroal.pool.DefaultMetricsRepository;
import io.agroal.pool.MetricsRepository;
import io.agroal.pool.Pool;
import io.agroal.pool.util.AgroalSynchronizer;
import io.agroal.pool.util.InterceptorHelper;
import io.agroal.pool.util.ListenerHelper;
import io.agroal.pool.util.StampedCopyOnWriteArrayList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Poolless
implements Pool {
    private final AgroalConnectionPoolConfiguration configuration;
    private final AgroalDataSourceListener[] listeners;
    private final StampedCopyOnWriteArrayList<ConnectionHandler> allConnections;
    private final AgroalSynchronizer synchronizer;
    private final ConnectionFactory connectionFactory;
    private final TransactionIntegration transactionIntegration;
    private final LongAccumulator maxUsed = new LongAccumulator(Math::max, Long.MIN_VALUE);
    private final AtomicInteger activeCount = new AtomicInteger();
    private List<AgroalPoolInterceptor> interceptors;
    private MetricsRepository metricsRepository;
    private volatile boolean shutdown;

    public Poolless(AgroalConnectionPoolConfiguration configuration, AgroalDataSourceListener ... listeners) {
        this.configuration = configuration;
        this.listeners = listeners;
        this.allConnections = new StampedCopyOnWriteArrayList<ConnectionHandler>(ConnectionHandler.class);
        this.synchronizer = new AgroalSynchronizer();
        this.connectionFactory = new ConnectionFactory(configuration.connectionFactoryConfiguration(), listeners);
        this.transactionIntegration = configuration.transactionIntegration();
    }

    @Override
    public void init() {
        if (!this.configuration.maxLifetime().isZero()) {
            ListenerHelper.fireOnInfo(this.listeners, "Max lifetime not supported in pool-less mode");
        }
        if (this.configuration.validateOnBorrow()) {
            ListenerHelper.fireOnInfo(this.listeners, "Validation on borrow is not supported in pool-less mode");
        }
        if (!this.configuration.idleValidationTimeout().isZero()) {
            ListenerHelper.fireOnInfo(this.listeners, "Idle validation not supported in pool-less mode");
        }
        if (!this.configuration.leakTimeout().isZero()) {
            ListenerHelper.fireOnInfo(this.listeners, "Leak detection not pro-active in pool-less mode");
        }
        if (!this.configuration.reapTimeout().isZero()) {
            ListenerHelper.fireOnInfo(this.listeners, "Connection reap not supported in pool-less mode");
        }
        if (this.configuration.initialSize() != 0) {
            ListenerHelper.fireOnInfo(this.listeners, "Initial size is zero in pool-less mode");
        }
        if (this.configuration.minSize() != 0) {
            ListenerHelper.fireOnInfo(this.listeners, "Min size always zero in pool-less mode");
        }
        this.transactionIntegration.addResourceRecoveryFactory((TransactionIntegration.ResourceRecoveryFactory)this.connectionFactory);
    }

    @Override
    public AgroalConnectionPoolConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int defaultJdbcIsolationLevel() {
        return this.connectionFactory.defaultJdbcIsolationLevel();
    }

    @Override
    public AgroalDataSourceListener[] getListeners() {
        return this.listeners;
    }

    @Override
    public List<AgroalPoolInterceptor> getPoolInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    @Override
    public void setPoolInterceptors(Collection<? extends AgroalPoolInterceptor> list) {
        if (list.stream().anyMatch(i -> i.getPriority() < 0)) {
            throw new IllegalArgumentException("Negative priority values on AgroalPoolInterceptor are reserved.");
        }
        if (list.isEmpty() && (this.interceptors == null || this.interceptors.isEmpty())) {
            return;
        }
        this.interceptors = list.stream().sorted(AgroalPoolInterceptor.DEFAULT_COMPARATOR).collect(Collectors.toList());
        Function<AgroalPoolInterceptor, String> interceptorName = i -> i.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(i)) + " (priority " + i.getPriority() + ")";
        ListenerHelper.fireOnInfo(this.listeners, "Pool interceptors: " + this.interceptors.stream().map(interceptorName).collect(Collectors.joining(" >>> ", "[", "]")));
    }

    @Override
    public void close() {
        this.transactionIntegration.removeResourceRecoveryFactory((TransactionIntegration.ResourceRecoveryFactory)this.connectionFactory);
        this.shutdown = true;
        for (ConnectionHandler handler : this.allConnections) {
            handler.setState(ConnectionHandler.State.FLUSH);
            this.destroyConnection(handler);
        }
        this.allConnections.clear();
        this.synchronizer.release(this.synchronizer.getQueueLength());
    }

    private long beforeAcquire() throws SQLException {
        ListenerHelper.fireBeforeConnectionAcquire(this.listeners);
        if (this.shutdown) {
            throw new SQLException("This pool is closed and does not handle any more connections!");
        }
        return this.metricsRepository.beforeConnectionAcquire();
    }

    private void checkMultipleAcquisition() throws SQLException {
        if (this.configuration.multipleAcquisition() != AgroalConnectionPoolConfiguration.MultipleAcquisitionAction.OFF) {
            for (ConnectionHandler handler : this.allConnections) {
                if (handler.getHoldingThread() != Thread.currentThread()) continue;
                switch (this.configuration.multipleAcquisition()) {
                    case STRICT: {
                        throw new SQLException("Acquisition of multiple connections by the same Thread.");
                    }
                    case WARN: {
                        ListenerHelper.fireOnWarning(this.listeners, "Acquisition of multiple connections by the same Thread. This can lead to pool exhaustion and eventually a deadlock!");
                    }
                }
                break;
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        long stamp = this.beforeAcquire();
        ConnectionHandler checkedOutHandler = this.handlerFromTransaction();
        if (checkedOutHandler != null) {
            this.transactionIntegration.associate((TransactionAware)checkedOutHandler, checkedOutHandler.getXaResource());
            return this.afterAcquire(stamp, checkedOutHandler);
        }
        this.checkMultipleAcquisition();
        try {
            checkedOutHandler = this.handlerFromSharedCache();
            this.transactionIntegration.associate((TransactionAware)checkedOutHandler, checkedOutHandler.getXaResource());
            InterceptorHelper.fireOnConnectionAcquiredInterceptor(this.interceptors, checkedOutHandler);
            return this.afterAcquire(stamp, checkedOutHandler);
        }
        catch (Throwable t) {
            if (checkedOutHandler != null) {
                this.flushHandler(checkedOutHandler);
            }
            throw t;
        }
    }

    private ConnectionHandler handlerFromTransaction() throws SQLException {
        return (ConnectionHandler)this.transactionIntegration.getTransactionAware();
    }

    private ConnectionHandler handlerFromSharedCache() throws SQLException {
        long remaining = this.configuration.acquisitionTimeout().toNanos();
        remaining = remaining > 0L ? remaining : Long.MAX_VALUE;
        try {
            while (true) {
                if (this.activeCount.incrementAndGet() <= this.configuration.maxSize()) {
                    try {
                        return this.createConnection();
                    }
                    catch (SQLException e) {
                        this.activeCount.decrementAndGet();
                        throw e;
                    }
                }
                this.activeCount.decrementAndGet();
                long synchronizationStamp = this.synchronizer.getStamp();
                long start = System.nanoTime();
                if (remaining < 0L || !this.synchronizer.tryAcquireNanos(synchronizationStamp, remaining)) {
                    throw new SQLException("Sorry, acquisition timeout!");
                }
                if (this.shutdown) {
                    throw new SQLException("Can't create new connection as the pool is shutting down");
                }
                remaining -= System.nanoTime() - start;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Interrupted while acquiring");
        }
    }

    private Connection afterAcquire(long metricsStamp, ConnectionHandler checkedOutHandler) throws SQLException {
        this.metricsRepository.afterConnectionAcquire(metricsStamp);
        ListenerHelper.fireOnConnectionAcquired(this.listeners, checkedOutHandler);
        if (!checkedOutHandler.isEnlisted()) {
            switch (this.configuration.transactionRequirement()) {
                case STRICT: {
                    this.returnConnectionHandler(checkedOutHandler);
                    throw new SQLException("Connection acquired without transaction.");
                }
                case WARN: {
                    ListenerHelper.fireOnWarning(this.listeners, new SQLException("Connection acquired without transaction."));
                }
            }
        }
        if (!this.configuration.leakTimeout().isZero() || this.configuration.multipleAcquisition() != AgroalConnectionPoolConfiguration.MultipleAcquisitionAction.OFF) {
            if (checkedOutHandler.getHoldingThread() != null && checkedOutHandler.getHoldingThread() != Thread.currentThread()) {
                Throwable warn = new Throwable("Shared connection between threads '" + checkedOutHandler.getHoldingThread().getName() + "' and '" + Thread.currentThread().getName() + "'");
                warn.setStackTrace(checkedOutHandler.getHoldingThread().getStackTrace());
                ListenerHelper.fireOnWarning(this.listeners, warn);
            }
            checkedOutHandler.setHoldingThread(Thread.currentThread());
            checkedOutHandler.touch();
            if (this.configuration.enhancedLeakReport()) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                checkedOutHandler.setAcquisitionStackTrace(Arrays.copyOfRange(stackTrace, 4, stackTrace.length));
            }
        }
        return checkedOutHandler.connectionWrapper();
    }

    @Override
    public void returnConnectionHandler(ConnectionHandler handler) throws SQLException {
        ListenerHelper.fireBeforeConnectionReturn(this.listeners, handler);
        try {
            if (!this.transactionIntegration.disassociate((TransactionAware)handler)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        InterceptorHelper.fireOnConnectionReturnInterceptor(this.interceptors, handler);
        this.flushHandler(handler);
    }

    public void onMetricsEnabled(boolean metricsEnabled) {
        this.metricsRepository = metricsEnabled ? new DefaultMetricsRepository(this) : new MetricsRepository.EmptyMetricsRepository();
    }

    @Override
    public MetricsRepository getMetrics() {
        return this.metricsRepository;
    }

    @Override
    public long activeCount() {
        return this.activeCount.get();
    }

    @Override
    public long availableCount() {
        return this.configuration.maxSize() - this.activeCount.get();
    }

    @Override
    public long maxUsedCount() {
        return this.maxUsed.get();
    }

    @Override
    public void resetMaxUsedCount() {
        this.maxUsed.reset();
    }

    @Override
    public long awaitingCount() {
        return this.synchronizer.getQueueLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHealthy(boolean newConnection) throws SQLException {
        if (newConnection) {
            this.activeCount.incrementAndGet();
        }
        ConnectionHandler healthHandler = newConnection ? this.createConnection() : this.handlerFromSharedCache();
        try {
            ListenerHelper.fireBeforeConnectionValidation(this.listeners, healthHandler);
            if (healthHandler.setState(ConnectionHandler.State.CHECKED_OUT, ConnectionHandler.State.VALIDATION) && healthHandler.isValid() && healthHandler.setState(ConnectionHandler.State.VALIDATION, ConnectionHandler.State.CHECKED_OUT)) {
                ListenerHelper.fireOnConnectionValid(this.listeners, healthHandler);
                boolean bl = true;
                return bl;
            }
            this.metricsRepository.afterConnectionInvalid();
            ListenerHelper.fireOnConnectionInvalid(this.listeners, healthHandler);
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnConnectionHandler(healthHandler);
        }
    }

    private ConnectionHandler createConnection() throws SQLException {
        ListenerHelper.fireBeforeConnectionCreation(this.listeners);
        long metricsStamp = this.metricsRepository.beforeConnectionCreation();
        try {
            ConnectionHandler handler = new ConnectionHandler(this.connectionFactory.createConnection(), this);
            this.metricsRepository.afterConnectionCreation(metricsStamp);
            ListenerHelper.fireOnConnectionCreation(this.listeners, handler);
            InterceptorHelper.fireOnConnectionCreateInterceptor(this.interceptors, handler);
            handler.setState(ConnectionHandler.State.CHECKED_OUT);
            this.allConnections.add(handler);
            this.maxUsed.accumulate(this.allConnections.size());
            ListenerHelper.fireOnConnectionPooled(this.listeners, handler);
            return handler;
        }
        catch (SQLException e) {
            ListenerHelper.fireOnWarning(this.listeners, e);
            throw e;
        }
    }

    @Override
    public void flushPool(AgroalDataSource.FlushMode mode) {
        block3: {
            block2: {
                if (mode != AgroalDataSource.FlushMode.ALL) break block2;
                for (ConnectionHandler handler : this.allConnections) {
                    ListenerHelper.fireBeforeConnectionFlush(this.listeners, handler);
                    this.flushHandler(handler);
                }
                break block3;
            }
            if (mode != AgroalDataSource.FlushMode.LEAK) break block3;
            for (ConnectionHandler handler : this.allConnections) {
                if (!handler.isLeak(this.configuration.leakTimeout())) continue;
                ListenerHelper.fireBeforeConnectionFlush(this.listeners, handler);
                this.flushHandler(handler);
            }
        }
    }

    private void flushHandler(ConnectionHandler handler) {
        handler.setState(ConnectionHandler.State.FLUSH);
        this.allConnections.remove(handler);
        this.activeCount.decrementAndGet();
        this.synchronizer.releaseConditional();
        this.metricsRepository.afterConnectionFlush();
        ListenerHelper.fireOnConnectionFlush(this.listeners, handler);
        this.destroyConnection(handler);
    }

    private void destroyConnection(ConnectionHandler handler) {
        ListenerHelper.fireBeforeConnectionDestroy(this.listeners, handler);
        try {
            InterceptorHelper.fireOnConnectionDestroyInterceptor(this.interceptors, handler);
            handler.closeConnection();
        }
        catch (SQLException e) {
            ListenerHelper.fireOnWarning(this.listeners, e);
        }
        this.metricsRepository.afterConnectionDestroy();
        ListenerHelper.fireOnConnectionDestroy(this.listeners, handler);
    }
}

