/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.nio.ByteBuffer;
import org.agrona.BufferUtil;

public class NetworkPublicationThreadLocals {
    private final ByteBuffer heartbeatBuffer;
    private final DataHeaderFlyweight dataHeader;
    private final ByteBuffer setupBuffer;
    private final SetupFlyweight setupHeader;
    private final ByteBuffer rttMeasurementBuffer;
    private final RttMeasurementFlyweight rttMeasurementHeader;

    public NetworkPublicationThreadLocals() {
        ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned((int)192, (int)64);
        byteBuffer.limit(32);
        this.heartbeatBuffer = byteBuffer.slice();
        this.dataHeader = new DataHeaderFlyweight(this.heartbeatBuffer);
        byteBuffer.limit(104).position(64);
        this.setupBuffer = byteBuffer.slice();
        this.setupHeader = new SetupFlyweight(this.setupBuffer);
        byteBuffer.limit(168).position(128);
        this.rttMeasurementBuffer = byteBuffer.slice();
        this.rttMeasurementHeader = new RttMeasurementFlyweight(this.rttMeasurementBuffer);
        this.dataHeader.version((short)0).flags((short)-64).headerType(1).frameLength(0);
        this.setupHeader.version((short)0).headerType(5).frameLength(40);
        this.rttMeasurementHeader.version((short)0).headerType(6).frameLength(40);
    }

    public ByteBuffer heartbeatBuffer() {
        return this.heartbeatBuffer;
    }

    public DataHeaderFlyweight heartbeatDataHeader() {
        return this.dataHeader;
    }

    public ByteBuffer setupBuffer() {
        return this.setupBuffer;
    }

    public SetupFlyweight setupHeader() {
        return this.setupHeader;
    }

    public ByteBuffer rttMeasurementBuffer() {
        return this.rttMeasurementBuffer;
    }

    public RttMeasurementFlyweight rttMeasurementHeader() {
        return this.rttMeasurementHeader;
    }
}

