/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.command.CounterUpdateFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.OperationSucceededFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.command.SubscriptionReadyFlyweight;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;

public class ClientProxy {
    private static final int WRITE_BUFFER_CAPACITY = 4096;
    private final UnsafeBuffer buffer = new UnsafeBuffer(ByteBuffer.allocateDirect(4096));
    private final BroadcastTransmitter transmitter;
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final SubscriptionReadyFlyweight subscriptionReady = new SubscriptionReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final OperationSucceededFlyweight operationSucceeded = new OperationSucceededFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();
    private final CounterUpdateFlyweight counterUpdate = new CounterUpdateFlyweight();

    public ClientProxy(BroadcastTransmitter transmitter) {
        this.transmitter = transmitter;
        this.errorResponse.wrap((MutableDirectBuffer)this.buffer, 0);
        this.imageReady.wrap((MutableDirectBuffer)this.buffer, 0);
        this.publicationReady.wrap((MutableDirectBuffer)this.buffer, 0);
        this.subscriptionReady.wrap((MutableDirectBuffer)this.buffer, 0);
        this.operationSucceeded.wrap((MutableDirectBuffer)this.buffer, 0);
        this.imageMessage.wrap((MutableDirectBuffer)this.buffer, 0);
        this.counterUpdate.wrap((MutableDirectBuffer)this.buffer, 0);
    }

    public void onError(long correlationId, ErrorCode errorCode, String errorMessage) {
        String msg = null == errorMessage ? "" : errorMessage;
        this.errorResponse.offendingCommandCorrelationId(correlationId).errorCode(errorCode).errorMessage(msg);
        this.transmit(3841, (DirectBuffer)this.buffer, 0, this.errorResponse.length());
    }

    public void onAvailableImage(long correlationId, int streamId, int sessionId, long subscriptionRegistrationId, int positionCounterId, String logFileName, String sourceIdentity) {
        this.imageReady.sessionId(sessionId).streamId(streamId).correlationId(correlationId).subscriptionRegistrationId(subscriptionRegistrationId).subscriberPositionId(positionCounterId).logFileName(logFileName).sourceIdentity(sourceIdentity);
        int length = this.imageReady.length();
        this.transmit(3842, (DirectBuffer)this.buffer, 0, length);
    }

    public void onPublicationReady(long correlationId, long registrationId, int streamId, int sessionId, String logFileName, int positionCounterId, int channelStatusCounterId, boolean isExclusive) {
        this.publicationReady.correlationId(correlationId).registrationId(registrationId).sessionId(sessionId).streamId(streamId).publicationLimitCounterId(positionCounterId).channelStatusCounterId(channelStatusCounterId).logFileName(logFileName);
        int length = this.publicationReady.length();
        int msgTypeId = isExclusive ? 3846 : 3843;
        this.transmit(msgTypeId, (DirectBuffer)this.buffer, 0, length);
    }

    public void onSubscriptionReady(long correlationId, int channelStatusCounterId) {
        this.subscriptionReady.correlationId(correlationId).channelStatusCounterId(channelStatusCounterId);
        this.transmit(3847, (DirectBuffer)this.buffer, 0, 12);
    }

    public void operationSucceeded(long correlationId) {
        this.operationSucceeded.correlationId(correlationId);
        this.transmit(3844, (DirectBuffer)this.buffer, 0, 8);
    }

    public void onUnavailableImage(long correlationId, long subscriptionRegistrationId, int streamId, String channel) {
        this.imageMessage.correlationId(correlationId).subscriptionRegistrationId(subscriptionRegistrationId).streamId(streamId).channel(channel);
        int length = this.imageMessage.length();
        this.transmit(3845, (DirectBuffer)this.buffer, 0, length);
    }

    public void onCounterReady(long correlationId, int counterId) {
        this.counterUpdate.correlationId(correlationId).counterId(counterId);
        this.transmit(3848, (DirectBuffer)this.buffer, 0, 12);
    }

    public void onUnavailableCounter(long registrationId, int counterId) {
        this.counterUpdate.correlationId(registrationId).counterId(counterId);
        this.transmit(3849, (DirectBuffer)this.buffer, 0, 12);
    }

    private void transmit(int msgTypeId, DirectBuffer buffer, int index, int length) {
        this.transmitter.transmit(msgTypeId, buffer, index, length);
    }
}

