/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SocketAddressUtil {
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("([^:]+)(?::([0-9]+))?");
    private static final Pattern IPV6_ADDRESS_PATTERN = Pattern.compile("\\[([0-9A-Fa-f:]+)(?:%[a-zA-Z0-9_.~-]+)?\\](?::([0-9]+))?");

    SocketAddressUtil() {
    }

    static InetSocketAddress parse(CharSequence cs) {
        if (null == cs) {
            throw new NullPointerException("Input string must not be null");
        }
        Matcher ipV4Matcher = IPV4_ADDRESS_PATTERN.matcher(cs);
        if (ipV4Matcher.matches()) {
            String host = ipV4Matcher.group(1);
            String port = ipV4Matcher.group(2);
            return SocketAddressUtil.newSocketAddress(host, port);
        }
        Matcher ipV6Matcher = IPV6_ADDRESS_PATTERN.matcher(cs);
        if (ipV6Matcher.matches()) {
            String host = ipV6Matcher.group(1);
            String port = ipV6Matcher.group(2);
            return SocketAddressUtil.newSocketAddress(host, port);
        }
        throw new IllegalArgumentException("Invalid format: " + cs);
    }

    private static InetSocketAddress newSocketAddress(String host, String port) {
        if (null == port) {
            throw new IllegalArgumentException("The 'port' portion of the address is required");
        }
        return new InetSocketAddress(host, Integer.parseInt(port));
    }
}

