/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.MultiDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import org.agrona.collections.ArrayListUtil;

class ManualMultiDestination
extends MultiDestination {
    private final ArrayList<InetSocketAddress> destinations = new ArrayList();

    ManualMultiDestination() {
    }

    @Override
    boolean isManualControlMode() {
        return true;
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress address) {
    }

    @Override
    int send(DatagramChannel datagramChannel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint) {
        int bytesToSend;
        ArrayList<InetSocketAddress> destinations = this.destinations;
        int position = buffer.position();
        int minBytesSent = bytesToSend = buffer.remaining();
        int size = destinations.size();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress destination = destinations.get(i);
            int bytesSent = 0;
            try {
                channelEndpoint.presend(buffer, destination);
                buffer.position(position);
                bytesSent = datagramChannel.send(buffer, destination);
            }
            catch (PortUnreachableException | ClosedChannelException iOException) {
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to send: " + bytesToSend, ex);
            }
            minBytesSent = Math.min(minBytesSent, bytesSent);
        }
        return minBytesSent;
    }

    @Override
    void addDestination(InetSocketAddress address) {
        this.destinations.add(address);
    }

    @Override
    void removeDestination(InetSocketAddress address) {
        int lastIndex;
        ArrayList<InetSocketAddress> destinations = this.destinations;
        for (int i = lastIndex = destinations.size() - 1; i >= 0; --i) {
            InetSocketAddress destination = destinations.get(i);
            if (!address.equals(destination)) continue;
            ArrayListUtil.fastUnorderedRemove(destinations, (int)i, (int)lastIndex);
            break;
        }
    }
}

