/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.MultiDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.NanoClock;

class DynamicMultiDestination
extends MultiDestination {
    private final long destinationTimeoutNs;
    private final NanoClock nanoClock;
    private final ArrayList<Destination> destinations = new ArrayList();

    DynamicMultiDestination(NanoClock nanoClock, long timeout) {
        this.nanoClock = nanoClock;
        this.destinationTimeoutNs = timeout;
    }

    @Override
    boolean isManualControlMode() {
        return false;
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress address) {
        ArrayList<Destination> destinations = this.destinations;
        long nowNs = this.nanoClock.nanoTime();
        boolean isExisting = false;
        long receiverId = msg.receiverId();
        int size = destinations.size();
        for (int i = 0; i < size; ++i) {
            Destination destination = destinations.get(i);
            if (receiverId != destination.receiverId || address.getPort() != destination.port) continue;
            destination.timeOfLastActivityNs = nowNs;
            isExisting = true;
            break;
        }
        if (!isExisting) {
            destinations.add(new Destination(nowNs, receiverId, address));
        }
    }

    @Override
    int send(DatagramChannel datagramChannel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint) {
        int lastIndex;
        int bytesToSend;
        ArrayList<Destination> destinations = this.destinations;
        long nowNs = this.nanoClock.nanoTime();
        int position = buffer.position();
        int minBytesSent = bytesToSend = buffer.remaining();
        for (int i = lastIndex = destinations.size() - 1; i >= 0; --i) {
            Destination destination = destinations.get(i);
            if (nowNs > destination.timeOfLastActivityNs + this.destinationTimeoutNs) {
                ArrayListUtil.fastUnorderedRemove(destinations, (int)i, (int)lastIndex);
                --lastIndex;
                continue;
            }
            int bytesSent = 0;
            try {
                channelEndpoint.presend(buffer, destination.address);
                buffer.position(position);
                bytesSent = datagramChannel.send(buffer, destination.address);
            }
            catch (PortUnreachableException | ClosedChannelException iOException) {
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to send: " + bytesToSend, ex);
            }
            minBytesSent = Math.min(minBytesSent, bytesSent);
        }
        return minBytesSent;
    }

    @Override
    void addDestination(InetSocketAddress address) {
    }

    @Override
    void removeDestination(InetSocketAddress address) {
    }

    static final class Destination {
        long timeOfLastActivityNs;
        long receiverId;
        int port;
        InetSocketAddress address;

        Destination(long now, long receiverId, InetSocketAddress address) {
            this.timeOfLastActivityNs = now;
            this.receiverId = receiverId;
            this.address = address;
            this.port = address.getPort();
        }
    }
}

