/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FrameDescriptor;
import org.agrona.BitUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class TermScanner {
    public static long scanForAvailability(UnsafeBuffer termBuffer, int offset, int maxLength) {
        int termOffset;
        int frameLength;
        int limit = Math.min(maxLength, termBuffer.capacity() - offset);
        int available = 0;
        int padding = 0;
        while ((frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, termOffset = offset + available)) > 0) {
            int alignedFrameLength = BitUtil.align((int)frameLength, (int)32);
            if (FrameDescriptor.isPaddingFrame(termBuffer, termOffset)) {
                padding = alignedFrameLength - 32;
                alignedFrameLength = 32;
            }
            if ((available += alignedFrameLength) > limit) {
                available -= alignedFrameLength;
                padding = 0;
                break;
            }
            if (0 == padding && available < limit) continue;
        }
        return TermScanner.pack(padding, available);
    }

    public static long pack(int padding, int available) {
        return (long)padding << 32 | (long)available;
    }

    public static int available(long result) {
        return (int)result;
    }

    public static int padding(long result) {
        return (int)(result >>> 32);
    }
}

