/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermUnblocker;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferUnblocker {
    public static boolean unblock(UnsafeBuffer[] termBuffers, UnsafeBuffer logMetaDataBuffer, long blockedPosition, int termLength) {
        int positionBitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        int blockedTermCount = (int)(blockedPosition >> positionBitsToShift);
        int blockedOffset = LogBufferDescriptor.computeTermOffsetFromPosition(blockedPosition, positionBitsToShift);
        int activeTermCount = LogBufferDescriptor.activeTermCount(logMetaDataBuffer);
        if (activeTermCount == blockedTermCount - 1 && blockedOffset == 0) {
            int currentTermId = LogBufferDescriptor.termId(LogBufferDescriptor.rawTailVolatile(logMetaDataBuffer, LogBufferDescriptor.indexByTermCount(activeTermCount)));
            return LogBufferDescriptor.rotateLog(logMetaDataBuffer, activeTermCount, currentTermId);
        }
        int blockedIndex = LogBufferDescriptor.indexByTermCount(blockedTermCount);
        long rawTail = LogBufferDescriptor.rawTailVolatile(logMetaDataBuffer, blockedIndex);
        int termId = LogBufferDescriptor.termId(rawTail);
        int tailOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        UnsafeBuffer termBuffer = termBuffers[blockedIndex];
        switch (TermUnblocker.unblock(logMetaDataBuffer, termBuffer, blockedOffset, tailOffset, termId)) {
            case UNBLOCKED_TO_END: {
                LogBufferDescriptor.rotateLog(logMetaDataBuffer, blockedTermCount, termId);
            }
            case UNBLOCKED: {
                return true;
            }
        }
        return false;
    }
}

