/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

public enum ErrorCode {
    GENERIC_ERROR(0),
    INVALID_CHANNEL(1),
    UNKNOWN_SUBSCRIPTION(2),
    UNKNOWN_PUBLICATION(3),
    CHANNEL_ENDPOINT_ERROR(4),
    UNKNOWN_COUNTER(5);

    static final ErrorCode[] ERROR_CODES;
    private final int value;

    private ErrorCode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ErrorCode get(int value) {
        if (value < 0 || value > ERROR_CODES.length - 1) {
            throw new IllegalStateException("invalid error code: " + value);
        }
        return ERROR_CODES[value];
    }

    static {
        ErrorCode[] errorCodes = ErrorCode.values();
        ERROR_CODES = new ErrorCode[errorCodes.length];
        for (ErrorCode errorCode : errorCodes) {
            int value = errorCode.value();
            if (null != ERROR_CODES[value]) {
                throw new IllegalStateException("value already in use: " + value);
            }
            ErrorCode.ERROR_CODES[value] = errorCode;
        }
    }
}

