/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.concurrent.UnsafeBuffer;

public class TermUnblocker {
    public static Status unblock(UnsafeBuffer logMetaDataBuffer, UnsafeBuffer termBuffer, int blockedOffset, int tailOffset, int termId) {
        Status status = Status.NO_ACTION;
        int frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, blockedOffset);
        if (frameLength < 0) {
            TermUnblocker.resetHeader(logMetaDataBuffer, termBuffer, blockedOffset, termId, -frameLength);
            status = Status.UNBLOCKED;
        } else if (0 == frameLength) {
            int length;
            int currentOffset;
            for (currentOffset = blockedOffset + 32; currentOffset < tailOffset; currentOffset += 32) {
                frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, currentOffset);
                if (frameLength == 0) continue;
                if (!TermUnblocker.scanBackToConfirmZeroed(termBuffer, currentOffset, blockedOffset)) break;
                length = currentOffset - blockedOffset;
                TermUnblocker.resetHeader(logMetaDataBuffer, termBuffer, blockedOffset, termId, length);
                status = Status.UNBLOCKED;
                break;
            }
            if (currentOffset == termBuffer.capacity() && 0 == FrameDescriptor.frameLengthVolatile(termBuffer, blockedOffset)) {
                length = currentOffset - blockedOffset;
                TermUnblocker.resetHeader(logMetaDataBuffer, termBuffer, blockedOffset, termId, length);
                status = Status.UNBLOCKED_TO_END;
            }
        }
        return status;
    }

    private static void resetHeader(UnsafeBuffer logMetaDataBuffer, UnsafeBuffer termBuffer, int termOffset, int termId, int frameLength) {
        LogBufferDescriptor.applyDefaultHeader(logMetaDataBuffer, termBuffer, termOffset);
        FrameDescriptor.frameType(termBuffer, termOffset, 0);
        FrameDescriptor.frameTermOffset(termBuffer, termOffset);
        FrameDescriptor.frameTermId(termBuffer, termOffset, termId);
        FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
    }

    private static boolean scanBackToConfirmZeroed(UnsafeBuffer buffer, int from, int limit) {
        boolean allZeros = true;
        for (int i = from - 32; i >= limit; i -= 32) {
            if (0 == FrameDescriptor.frameLengthVolatile(buffer, i)) continue;
            allZeros = false;
            break;
        }
        return allZeros;
    }

    public static enum Status {
        NO_ACTION,
        UNBLOCKED,
        UNBLOCKED_TO_END;

    }
}

