/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import io.aeron.shadow.org.HdrHistogram.Histogram;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.ToIntFunction;
import org.agrona.SystemUtil;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.SigInt;
import org.agrona.hints.ThreadHints;
import org.agrona.nio.NioSelectedKeySet;

public class SendHackSelectReceiveUdpPing {
    public static void main(String[] args) throws IOException {
        if (SystemUtil.isWindows()) {
            HighResolutionTimer.enable();
        }
        InetSocketAddress sendAddress = new InetSocketAddress(Common.PING_DEST, 20124);
        Histogram histogram = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1408);
        DatagramChannel receiveChannel = DatagramChannel.open();
        Common.init(receiveChannel);
        receiveChannel.bind(new InetSocketAddress(Common.PONG_DEST, 20123));
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        Selector selector = Selector.open();
        receiveChannel.register(selector, 1, null);
        NioSelectedKeySet keySet = Common.keySet(selector);
        MutableLong sequence = new MutableLong();
        ToIntFunction<SelectionKey> handler = key -> {
            try {
                buffer.clear();
                receiveChannel.receive(buffer);
                long receivedSequenceNumber = buffer.getLong(0);
                long receivedTimestamp = buffer.getLong(8);
                long durationNs = System.nanoTime() - receivedTimestamp;
                if (receivedSequenceNumber != sequence.get()) {
                    throw new IllegalStateException("Data Loss: " + sequence + " to " + receivedSequenceNumber);
                }
                histogram.recordValue(durationNs);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return 1;
        };
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            SendHackSelectReceiveUdpPing.measureRoundTrip(histogram, sendAddress, buffer, sendChannel, handler, selector, keySet, sequence, running);
            histogram.reset();
            System.gc();
            LockSupport.parkNanos(1000000000L);
        }
    }

    private static void measureRoundTrip(Histogram histogram, InetSocketAddress sendAddress, ByteBuffer buffer, DatagramChannel sendChannel, ToIntFunction<SelectionKey> handler, Selector selector, NioSelectedKeySet keySet, MutableLong sequence, AtomicBoolean running) throws IOException {
        for (int i = 0; i < 10000; ++i) {
            sequence.set(i);
            long timestampNs = System.nanoTime();
            buffer.clear();
            buffer.putLong(i);
            buffer.putLong(timestampNs);
            buffer.flip();
            sendChannel.send(buffer, sendAddress);
            while (selector.selectNow() == 0) {
                if (!running.get()) {
                    return;
                }
                ThreadHints.onSpinWait();
            }
            keySet.forEach(handler);
        }
        histogram.outputPercentileDistribution(System.out, 1000.0);
    }
}

