/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.RecordingSignalConsumer;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.exceptions.AeronException;

public final class RecordingSignalCapture
implements RecordingSignalConsumer {
    private long controlSessionId;
    private long correlationId;
    private long subscriptionId;
    private long recordingId;
    private long position;
    private RecordingSignal signal;

    @Override
    public void onSignal(long controlSessionId, long correlationId, long recordingId, long subscriptionId, long position, RecordingSignal signal) {
        this.controlSessionId = controlSessionId;
        this.correlationId = correlationId;
        this.subscriptionId = subscriptionId;
        if (-1L != recordingId) {
            this.recordingId = recordingId;
        }
        if (-1L != position) {
            this.position = position;
        }
        this.signal = signal;
    }

    public void awaitSignalForCorrelationId(AeronArchive archive, long expectedCorrelationId, RecordingSignal expectedSignal) {
        while (expectedCorrelationId != this.correlationId || expectedSignal != this.signal) {
            if (0 == archive.pollForRecordingSignals()) {
                Thread.yield();
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new AeronException("unexpected interrupt");
            }
            if (expectedCorrelationId != this.correlationId) continue;
            if (expectedSignal == this.signal) {
                return;
            }
            if (RecordingSignal.REPLICATE_END != this.signal) continue;
            throw new AeronException("unexpected end of replication: correlationId=" + this.correlationId);
        }
    }

    public void awaitSignalForRecordingId(AeronArchive archive, long expectedRecordingId, RecordingSignal expectedSignal) {
        while (expectedRecordingId != this.recordingId || expectedSignal != this.signal) {
            if (0 == archive.pollForRecordingSignals()) {
                Thread.yield();
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new AeronException("unexpected interrupt");
            }
            if (expectedRecordingId != this.recordingId) continue;
            if (expectedSignal == this.signal) {
                return;
            }
            if (RecordingSignal.REPLICATE_END != this.signal) continue;
            throw new AeronException("unexpected end of replication: correlationId=" + this.correlationId);
        }
    }

    public void reset() {
        this.correlationId = -1L;
        this.controlSessionId = -1L;
        this.subscriptionId = -1L;
        this.recordingId = -1L;
        this.position = -1L;
        this.signal = null;
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public long subscriptionId() {
        return this.subscriptionId;
    }

    public long recordingId() {
        return this.recordingId;
    }

    public long position() {
        return this.position;
    }

    public RecordingSignal signal() {
        return this.signal;
    }
}

