/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermUnblocker;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferUnblocker {
    public static boolean unblock(UnsafeBuffer[] termBuffers, UnsafeBuffer logMetaDataBuffer, long blockedPosition, int termLength) {
        int positionBitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        int blockedTermCount = (int)(blockedPosition >> positionBitsToShift);
        int blockedOffset = (int)blockedPosition & termLength - 1;
        int activeTermCount = LogBufferDescriptor.activeTermCount(logMetaDataBuffer);
        if (activeTermCount == blockedTermCount - 1 && blockedOffset == 0) {
            int currentTermId = LogBufferDescriptor.termId(LogBufferDescriptor.rawTailVolatile(logMetaDataBuffer, LogBufferDescriptor.indexByTermCount(activeTermCount)));
            LogBufferDescriptor.rotateLog(logMetaDataBuffer, activeTermCount, currentTermId);
            return true;
        }
        int blockedIndex = LogBufferDescriptor.indexByTermCount(blockedTermCount);
        long rawTail = LogBufferDescriptor.rawTailVolatile(logMetaDataBuffer, blockedIndex);
        int termId = LogBufferDescriptor.termId(rawTail);
        int tailOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        UnsafeBuffer termBuffer = termBuffers[blockedIndex];
        switch (TermUnblocker.unblock(logMetaDataBuffer, termBuffer, blockedOffset, tailOffset, termId)) {
            case NO_ACTION: {
                break;
            }
            case UNBLOCKED_TO_END: {
                LogBufferDescriptor.rotateLog(logMetaDataBuffer, blockedTermCount, termId);
                return true;
            }
            case UNBLOCKED: {
                return true;
            }
        }
        return false;
    }
}

