/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.NativeBigEndianHeaderWriter;
import java.nio.ByteOrder;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

public class HeaderWriter {
    final long versionFlagsType;
    final long sessionId;
    final long streamId;

    HeaderWriter(long versionFlagsType, long sessionId, long streamId) {
        this.versionFlagsType = versionFlagsType;
        this.sessionId = sessionId;
        this.streamId = streamId;
    }

    HeaderWriter(UnsafeBuffer defaultHeader) {
        this.versionFlagsType = (long)defaultHeader.getInt(4) << 32;
        this.sessionId = (long)defaultHeader.getInt(12) << 32;
        this.streamId = (long)defaultHeader.getInt(16) & 0xFFFFFFFFL;
    }

    public static HeaderWriter newInstance(UnsafeBuffer defaultHeader) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            return new HeaderWriter(defaultHeader);
        }
        return new NativeBigEndianHeaderWriter(defaultHeader);
    }

    public void write(UnsafeBuffer termBuffer, int offset, int length, int termId) {
        termBuffer.putLongOrdered(offset + 0, this.versionFlagsType | (long)(-length) & 0xFFFFFFFFL);
        UnsafeAccess.UNSAFE.storeFence();
        termBuffer.putLong(offset + 8, this.sessionId | (long)offset);
        termBuffer.putLong(offset + 16, this.streamId | (long)termId << 32);
    }
}

