/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import io.aeron.driver.status.SystemCounterDescriptor;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.status.CountersReader;
import org.agrona.concurrent.status.StatusIndicator;
import org.agrona.concurrent.status.StatusIndicatorReader;
import org.agrona.concurrent.status.UnsafeBufferStatusIndicator;

public class StatusUtil {
    public static StatusIndicator controllableIdleStrategy(CountersReader countersReader) {
        UnsafeBufferStatusIndicator statusIndicator = null;
        MutableInteger id = new MutableInteger(-1);
        countersReader.forEach((counterId, label) -> {
            if (counterId == SystemCounterDescriptor.CONTROLLABLE_IDLE_STRATEGY.id() && label.equals(SystemCounterDescriptor.CONTROLLABLE_IDLE_STRATEGY.label())) {
                id.value = counterId;
            }
        });
        if (-1 != id.value) {
            statusIndicator = new UnsafeBufferStatusIndicator(countersReader.valuesBuffer(), id.value);
        }
        return statusIndicator;
    }

    public static StatusIndicatorReader sendChannelStatus(CountersReader countersReader, String channel) {
        UnsafeBufferStatusIndicator statusReader = null;
        MutableInteger id = new MutableInteger(-1);
        countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
            if (typeId == 6 && channel.startsWith(keyBuffer.getStringAscii(0))) {
                id.value = counterId;
            }
        });
        if (-1 != id.value) {
            statusReader = new UnsafeBufferStatusIndicator(countersReader.valuesBuffer(), id.value);
        }
        return statusReader;
    }

    public static StatusIndicatorReader receiveChannelStatus(CountersReader countersReader, String channel) {
        UnsafeBufferStatusIndicator statusReader = null;
        MutableInteger id = new MutableInteger(-1);
        countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
            if (typeId == 7 && channel.startsWith(keyBuffer.getStringAscii(0))) {
                id.value = counterId;
            }
        });
        if (-1 != id.value) {
            statusReader = new UnsafeBufferStatusIndicator(countersReader.valuesBuffer(), id.value);
        }
        return statusReader;
    }
}

