/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.NameResolver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.agrona.AsciiEncoding;
import org.agrona.Strings;

class SocketAddressParser {
    SocketAddressParser() {
    }

    static InetSocketAddress parse(String value, String uriParamName, boolean isReResolution, NameResolver nameResolver) {
        if (Strings.isEmpty(value)) {
            throw new NullPointerException("input string must not be null or empty");
        }
        String nameAndPort = nameResolver.lookup(value, uriParamName, isReResolution);
        ParseResult result = SocketAddressParser.tryParseIpV4(nameAndPort);
        if (null == result) {
            result = SocketAddressParser.tryParseIpV6(nameAndPort);
        }
        if (null == result) {
            throw new IllegalArgumentException("invalid format: " + nameAndPort);
        }
        InetAddress inetAddress = nameResolver.resolve(result.host, uriParamName, isReResolution);
        return null == inetAddress ? InetSocketAddress.createUnresolved(result.host, result.port) : new InetSocketAddress(inetAddress, result.port);
    }

    static boolean isMulticastAddress(String hostAndPort) {
        ParseResult result = SocketAddressParser.tryParseIpV4(hostAndPort);
        if (null != result) {
            String host = result.host;
            int dotIndex = 0;
            int end = host.length() - 1;
            for (int i = 0; i <= end; ++i) {
                char c = host.charAt(i);
                if ('.' == c || end == i) {
                    int firstByte;
                    int length;
                    int n = length = end == i ? i - dotIndex : i - 1 - dotIndex;
                    if (length <= 0 || length > 3) {
                        return false;
                    }
                    if (0 == dotIndex && ((firstByte = AsciiEncoding.parseIntAscii(host, 0, i)) > 255 || 224 != (firstByte & 0xF0))) {
                        return false;
                    }
                    dotIndex = i;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        result = SocketAddressParser.tryParseIpV6(hostAndPort);
        if (null != result) {
            String firstByte = result.host.substring(0, 2);
            return "ff".equalsIgnoreCase(firstByte);
        }
        throw new IllegalArgumentException("invalid format: " + hostAndPort);
    }

    private static ParseResult tryParseIpV4(String str) {
        IpV4State state = IpV4State.HOST;
        int separatorIndex = -1;
        int length = str.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (state) {
                case HOST: {
                    if (':' != c) continue block4;
                    separatorIndex = i;
                    state = IpV4State.PORT;
                    continue block4;
                }
                case PORT: {
                    if (c >= '0' && '9' >= c) continue block4;
                    return null;
                }
            }
        }
        if (-1 != separatorIndex && 1 < length - separatorIndex) {
            String hostname = str.substring(0, separatorIndex);
            int portIndex = separatorIndex + 1;
            int port = AsciiEncoding.parseIntAscii(str, portIndex, length - portIndex);
            return new ParseResult(hostname, port);
        }
        throw new IllegalArgumentException("address:port is required for ipv4: " + str);
    }

    private static ParseResult tryParseIpV6(String str) {
        IpV6State state = IpV6State.START_ADDR;
        int portIndex = -1;
        int scopeIndex = -1;
        int length = str.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (state) {
                case START_ADDR: {
                    if ('[' == c) {
                        state = IpV6State.HOST;
                        continue block7;
                    }
                    return null;
                }
                case HOST: {
                    if (']' == c) {
                        state = IpV6State.END_ADDR;
                        continue block7;
                    }
                    if ('%' == c) {
                        scopeIndex = i;
                        state = IpV6State.SCOPE;
                        continue block7;
                    }
                    if (':' == c || c >= 'a' && 'f' >= c || c >= 'A' && 'F' >= c || c >= '0' && '9' >= c) continue block7;
                    return null;
                }
                case SCOPE: {
                    if (']' == c) {
                        state = IpV6State.END_ADDR;
                        continue block7;
                    }
                    if ('_' == c || '.' == c || '~' == c || '-' == c || c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c || c >= '0' && '9' >= c) continue block7;
                    return null;
                }
                case END_ADDR: {
                    if (':' == c) {
                        portIndex = i;
                        state = IpV6State.PORT;
                        continue block7;
                    }
                    return null;
                }
                case PORT: {
                    if (c >= '0' && '9' >= c) continue block7;
                    return null;
                }
            }
        }
        if (-1 != portIndex && 1 < length - portIndex) {
            String hostname = str.substring(1, scopeIndex != -1 ? scopeIndex : portIndex - 1);
            int port = AsciiEncoding.parseIntAscii(str, ++portIndex, length - portIndex);
            return new ParseResult(hostname, port);
        }
        throw new IllegalArgumentException("[address]:port is required for ipv6: " + str);
    }

    private static final class ParseResult {
        final String host;
        final int port;

        private ParseResult(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    static enum IpV6State {
        START_ADDR,
        HOST,
        SCOPE,
        END_ADDR,
        PORT;

    }

    static enum IpV4State {
        HOST,
        PORT;

    }
}

