/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.ErrorCode;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.media.DynamicSndMultiDestination;
import io.aeron.driver.media.ManualSndMultiDestination;
import io.aeron.driver.media.MultiSndDestination;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.MdcDestinations;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.ResponseSetupFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import io.aeron.status.ChannelEndpointStatus;
import io.aeron.status.LocalSocketAddressStatus;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Hashing;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class SendChannelEndpoint
extends UdpChannelTransport {
    static final long DESTINATION_TIMEOUT = TimeUnit.SECONDS.toNanos(5L);
    private int refCount = 0;
    private long timeOfLastResolutionNs;
    private final Long2ObjectHashMap<NetworkPublication> publicationBySessionAndStreamId = new Long2ObjectHashMap();
    private final MultiSndDestination multiSndDestination;
    private final AtomicCounter statusMessagesReceived;
    private final AtomicCounter nakMessagesReceived;
    private final AtomicCounter statusIndicator;
    private final boolean isChannelSendTimestampEnabled;
    private final EpochNanoClock sendTimestampClock;
    private final UnsafeBuffer bufferForTimestamping = new UnsafeBuffer();
    private AtomicCounter localSocketAddressIndicator;
    private AtomicCounter mdcDestinationsCounter;

    public SendChannelEndpoint(UdpChannel udpChannel, AtomicCounter statusIndicator, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteControl(), udpChannel.localControl(), udpChannel.isMultiDestination() || udpChannel.isResponseControlMode() ? null : udpChannel.remoteData(), context.senderPortManager(), context);
        this.nakMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.NAK_MESSAGES_RECEIVED);
        this.statusMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.STATUS_MESSAGES_RECEIVED);
        this.statusIndicator = statusIndicator;
        MultiSndDestination multiSndDestination = null;
        if (udpChannel.isManualControlMode()) {
            multiSndDestination = new ManualSndMultiDestination(context.senderCachedNanoClock());
        } else if (udpChannel.isDynamicControlMode()) {
            multiSndDestination = new DynamicSndMultiDestination(context.senderCachedNanoClock());
        }
        this.multiSndDestination = multiSndDestination;
        this.isChannelSendTimestampEnabled = udpChannel.isChannelSendTimestampEnabled();
        this.sendTimestampClock = context.channelSendTimestampClock();
    }

    public void localSocketAddressIndicator(AtomicCounter counter) {
        this.localSocketAddressIndicator = counter;
    }

    public void decRef() {
        --this.refCount;
    }

    public void incRef() {
        ++this.refCount;
    }

    public void openChannel(DriverConductorProxy conductorProxy) {
        if (conductorProxy.notConcurrent()) {
            this.openDatagramChannel(this.statusIndicator);
        } else {
            try {
                this.openDatagramChannel(this.statusIndicator);
            }
            catch (Exception ex) {
                conductorProxy.channelEndpointError(this.statusIndicator.id(), ex);
                throw ex;
            }
        }
        LocalSocketAddressStatus.updateBindAddress(Objects.requireNonNull(this.localSocketAddressIndicator, "localSocketAddressIndicator not allocated"), this.bindAddressAndPort(), this.context.countersMetaDataBuffer());
        this.localSocketAddressIndicator.setOrdered(1L);
    }

    public String originalUriString() {
        return this.udpChannel().originalUriString();
    }

    public int statusIndicatorCounterId() {
        return this.statusIndicator.id();
    }

    public void indicateActive() {
        long currentStatus = this.statusIndicator.get();
        if (currentStatus != 0L) {
            throw new IllegalStateException("channel cannot be registered unless INITIALIZING: status=" + ChannelEndpointStatus.status(currentStatus));
        }
        this.statusIndicator.appendToLabel(this.bindAddressAndPort());
        this.statusIndicator.setOrdered(1L);
    }

    public void closeIndicators() {
        CloseHelper.close(this.statusIndicator);
        CloseHelper.close(this.localSocketAddressIndicator);
        CloseHelper.close(this.mdcDestinationsCounter);
    }

    public boolean shouldBeClosed() {
        return 0 == this.refCount && !this.statusIndicator.isClosed();
    }

    public void registerForSend(NetworkPublication publication) {
        this.publicationBySessionAndStreamId.put(Hashing.compoundKey(publication.sessionId(), publication.streamId()), publication);
    }

    public void unregisterForSend(NetworkPublication publication) {
        this.publicationBySessionAndStreamId.remove(Hashing.compoundKey(publication.sessionId(), publication.streamId()));
    }

    public int send(ByteBuffer buffer) {
        int bytesSent = 0;
        if (this.isChannelSendTimestampEnabled) {
            this.applyChannelSendTimestamp(buffer);
        }
        if (null != this.sendDatagramChannel) {
            int bytesToSend = buffer.remaining();
            if (null == this.multiSndDestination) {
                try {
                    this.sendHook(buffer, this.connectAddress);
                    if (this.sendDatagramChannel.isConnected()) {
                        bytesSent = this.sendDatagramChannel.write(buffer);
                    }
                }
                catch (PortUnreachableException portUnreachableException) {
                }
                catch (IOException ex) {
                    SendChannelEndpoint.sendError(bytesToSend, ex, this.connectAddress);
                }
            } else {
                bytesSent = this.multiSndDestination.send(this.sendDatagramChannel, buffer, this, bytesToSend);
            }
        }
        return bytesSent;
    }

    public int send(ByteBuffer buffer, InetSocketAddress endpointAddress) {
        int bytesSent = 0;
        if (this.isChannelSendTimestampEnabled) {
            this.applyChannelSendTimestamp(buffer);
        }
        if (null != this.sendDatagramChannel) {
            int bytesToSend = buffer.remaining();
            try {
                this.sendHook(buffer, endpointAddress);
                bytesSent = this.sendDatagramChannel.send(buffer, endpointAddress);
            }
            catch (PortUnreachableException portUnreachableException) {
            }
            catch (IOException ex) {
                SendChannelEndpoint.sendError(bytesToSend, ex, this.connectAddress);
            }
        }
        return bytesSent;
    }

    public void checkForReResolution(long nowNs, DriverConductorProxy conductorProxy) {
        if (this.udpChannel.isManualControlMode()) {
            this.multiSndDestination.checkForReResolution(this, nowNs, conductorProxy);
        } else if (this.udpChannel.hasExplicitEndpoint() && !this.udpChannel.isMulticast() && this.statusMessageTimeout(nowNs) && this.timeOfLastResolutionNs + DESTINATION_TIMEOUT - nowNs < 0L) {
            this.timeOfLastResolutionNs = nowNs;
            String endpoint = this.udpChannel.channelUri().get("endpoint");
            conductorProxy.reResolveEndpoint(endpoint, this, this.udpChannel.remoteData());
        }
    }

    public void onStatusMessage(StatusMessageFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress, DriverConductorProxy conductorProxy) {
        NetworkPublication publication;
        int sessionId = msg.sessionId();
        int streamId = msg.streamId();
        this.statusMessagesReceived.incrementOrdered();
        if (null != this.multiSndDestination) {
            this.multiSndDestination.onStatusMessage(msg, srcAddress);
        }
        if (null != (publication = this.publicationBySessionAndStreamId.get(Hashing.compoundKey(sessionId, streamId)))) {
            if (128 == (msg.flags() & 0x80)) {
                publication.triggerSendSetupFrame(msg, srcAddress);
            } else {
                publication.onStatusMessage(msg, srcAddress, conductorProxy);
            }
        }
    }

    public void onNakMessage(NakFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        long key = Hashing.compoundKey(msg.sessionId(), msg.streamId());
        NetworkPublication publication = this.publicationBySessionAndStreamId.get(key);
        if (null != publication) {
            publication.onNak(msg.termId(), msg.termOffset(), msg.length());
            this.nakMessagesReceived.incrementOrdered();
        }
    }

    public void onRttMeasurement(RttMeasurementFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        long key = Hashing.compoundKey(msg.sessionId(), msg.streamId());
        NetworkPublication publication = this.publicationBySessionAndStreamId.get(key);
        if (null != publication) {
            publication.onRttMeasurement(msg, srcAddress);
        }
    }

    public void onResponseSetup(ResponseSetupFlyweight msg, UnsafeBuffer unsafeBuffer, int length, InetSocketAddress srcAddress, DriverConductorProxy conductorProxy) {
        long responseCorrelationId;
        long key = Hashing.compoundKey(msg.sessionId(), msg.streamId());
        NetworkPublication publication = this.publicationBySessionAndStreamId.get(key);
        if (null != publication && -1L != (responseCorrelationId = publication.responseCorrelationId())) {
            conductorProxy.responseSetup(responseCorrelationId, msg.responseSessionId());
        }
    }

    public void validateAllowsManualControl() {
        if (!(this.multiSndDestination instanceof ManualSndMultiDestination)) {
            throw new ControlProtocolException(ErrorCode.INVALID_CHANNEL, "channel does not allow manual control");
        }
    }

    public void addDestination(ChannelUri channelUri, InetSocketAddress address) {
        this.multiSndDestination.addDestination(channelUri, address);
    }

    public void removeDestination(ChannelUri channelUri, InetSocketAddress address) {
        this.multiSndDestination.removeDestination(channelUri, address);
    }

    public void resolutionChange(String endpoint, InetSocketAddress newAddress) {
        if (null != this.multiSndDestination) {
            this.multiSndDestination.updateDestination(endpoint, newAddress);
        } else {
            this.updateEndpoint(newAddress, this.statusIndicator);
        }
    }

    public void allocateDestinationsCounterForMdc(MutableDirectBuffer tempBuffer, CountersManager countersManager, long registrationId, String originalUriString) {
        if (null != this.multiSndDestination) {
            this.mdcDestinationsCounter = MdcDestinations.allocate(tempBuffer, countersManager, registrationId, originalUriString);
            this.multiSndDestination.destinationsCounter(this.mdcDestinationsCounter);
        }
    }

    private boolean statusMessageTimeout(long nowNs) {
        for (NetworkPublication publication : this.publicationBySessionAndStreamId.values()) {
            if (publication.timeOfLastStatusMessageNs() + DESTINATION_TIMEOUT - nowNs < 0L) continue;
            return false;
        }
        return true;
    }

    private void applyChannelSendTimestamp(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (length >= 32) {
            int offset;
            this.bufferForTimestamping.wrap(buffer, buffer.position(), length);
            int type = this.bufferForTimestamping.getShort(6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int flags = this.bufferForTimestamping.getByte(5) & 0xFF;
            if (1 == type && 0 != (0x80 & flags) && !DataHeaderFlyweight.isHeartbeat(this.bufferForTimestamping, length) && 32 + (offset = this.udpChannel.channelSendTimestampOffset()) + 8 <= length) {
                this.bufferForTimestamping.putLong(32 + offset, this.sendTimestampClock.nanoTime(), ByteOrder.LITTLE_ENDIAN);
            }
        }
    }
}

