/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.ext.LossGenerator;
import java.net.InetSocketAddress;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;

public class FixedLossGenerator
implements LossGenerator {
    private final int termId;
    private final int termOffset;
    private final int length;
    private final BiInt2ObjectMap<MutableInteger> streamAndSessionIdToOffsetMap = new BiInt2ObjectMap();

    public FixedLossGenerator(int termId, int termOffset, int length) {
        this.termId = termId;
        this.termOffset = termOffset;
        this.length = length;
    }

    @Override
    public boolean shouldDropFrame(InetSocketAddress address, UnsafeBuffer buffer, int length) {
        return false;
    }

    @Override
    public boolean shouldDropFrame(InetSocketAddress address, UnsafeBuffer buffer, int streamId, int sessionId, int termId, int termOffset, int length) {
        if (this.termId == termId) {
            MutableInteger trackingOffset = this.streamAndSessionIdToOffsetMap.get(streamId, sessionId);
            if (null == trackingOffset) {
                trackingOffset = new MutableInteger(termOffset);
                this.streamAndSessionIdToOffsetMap.put(streamId, sessionId, trackingOffset);
            }
            if (trackingOffset.get() < this.termOffset + this.length && termOffset <= trackingOffset.get() && trackingOffset.get() < termOffset + length) {
                trackingOffset.set(termOffset + length);
                return true;
            }
        }
        return false;
    }
}

